/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.TagProjection;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyGrammar
implements DependencyGrammar {
    protected TagProjection tagProjection;
    private static Numberer tagNumberer;
    private static Numberer wordNumberer;
    protected int numTagBins;
    protected int[] tagBin;
    protected TreebankLanguagePack tlp;
    protected boolean directional;
    protected boolean useDistance;
    protected boolean useCoarseDistance;
    protected static final IntTaggedWord stopTW;
    protected static final IntTaggedWord wildTW;
    private transient IntDependency tempDependency = new IntDependency(-2, -2, -2, -2, false, 0);
    private transient IntDependency internTempDependency = null;
    protected transient Map<IntDependency, IntDependency> expandDependencyMap = new HashMap<IntDependency, IntDependency>();
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 2L;

    public AbstractDependencyGrammar(TreebankLanguagePack tlp, TagProjection tagProjection, boolean directional, boolean useDistance, boolean useCoarseDistance) {
        this.tlp = tlp;
        this.tagProjection = tagProjection;
        this.directional = directional;
        this.useDistance = useDistance;
        this.useCoarseDistance = useCoarseDistance;
        this.initTagBins();
    }

    protected static Numberer tagNumberer() {
        if (tagNumberer == null) {
            tagNumberer = Numberer.getGlobalNumberer("tags");
        }
        return tagNumberer;
    }

    protected static Numberer wordNumberer() {
        if (wordNumberer == null) {
            wordNumberer = Numberer.getGlobalNumberer("words");
        }
        return wordNumberer;
    }

    @Override
    public void tune(Collection<Tree> trees) {
    }

    @Override
    public int numTagBins() {
        return this.numTagBins;
    }

    @Override
    public int tagBin(int tag) {
        if (tag < 0) {
            return tag;
        }
        return this.tagBin[tag];
    }

    public static boolean rootTW(IntTaggedWord rTW) {
        return rTW.tag == AbstractDependencyGrammar.tagNumberer().number(".$$.");
    }

    protected short valenceBin(int distance) {
        if (!this.useDistance) {
            return 0;
        }
        if (distance < 0) {
            return -1;
        }
        if (distance == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int numDistBins() {
        return this.useCoarseDistance ? 4 : 5;
    }

    @Override
    public short distanceBin(int distance) {
        if (!this.useDistance) {
            return 0;
        }
        if (this.useCoarseDistance) {
            return AbstractDependencyGrammar.courseDistanceBin(distance);
        }
        return AbstractDependencyGrammar.regDistanceBin(distance);
    }

    public static short regDistanceBin(int distance) {
        if (distance <= 0) {
            return 0;
        }
        if (distance <= 1) {
            return 1;
        }
        if (distance <= 5) {
            return 2;
        }
        if (distance <= 10) {
            return 3;
        }
        return 4;
    }

    public static short courseDistanceBin(int distance) {
        if (distance <= 0) {
            return 0;
        }
        if (distance <= 2) {
            return 1;
        }
        if (distance <= 5) {
            return 2;
        }
        return 3;
    }

    private void initTagBins() {
        Numberer tagBinNumberer = new Numberer();
        this.tagBin = new int[AbstractDependencyGrammar.tagNumberer().total()];
        for (int t = 0; t < this.tagBin.length; ++t) {
            String tagStr = (String)AbstractDependencyGrammar.tagNumberer().object(t);
            String binStr = this.tagProjection == null ? tagStr : this.tagProjection.project(tagStr);
            this.tagBin[t] = tagBinNumberer.number(binStr);
        }
        this.numTagBins = tagBinNumberer.total();
    }

    @Override
    public double score(IntDependency dependency) {
        short hTBackup = dependency.head.tag;
        short aTBackup = dependency.arg.tag;
        dependency.head.tag = (short)this.tagBin(dependency.head.tag);
        dependency.arg.tag = (short)this.tagBin(dependency.arg.tag);
        double s = this.scoreTB(dependency);
        dependency.head.tag = hTBackup;
        dependency.arg.tag = aTBackup;
        return s;
    }

    @Override
    public double score(int headWord, int headTag, int argWord, int argTag, boolean leftHeaded, int dist) {
        this.tempDependency.head.word = headWord;
        this.tempDependency.head.tag = (short)headTag;
        this.tempDependency.arg.word = argWord;
        this.tempDependency.arg.tag = (short)argTag;
        this.tempDependency.leftHeaded = leftHeaded;
        this.tempDependency.distance = (short)dist;
        return this.score(this.tempDependency);
    }

    @Override
    public double scoreTB(int headWord, int headTag, int argWord, int argTag, boolean leftHeaded, int dist) {
        this.tempDependency.head.word = headWord;
        this.tempDependency.head.tag = (short)headTag;
        this.tempDependency.arg.word = argWord;
        this.tempDependency.arg.tag = (short)argTag;
        this.tempDependency.leftHeaded = leftHeaded;
        this.tempDependency.distance = (short)dist;
        return this.scoreTB(this.tempDependency);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tempDependency = new IntDependency(-2, -2, -2, -2, false, 0);
    }

    @Override
    public void readData(BufferedReader in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(PrintWriter out2) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected IntDependency intern(IntTaggedWord headTW, IntTaggedWord argTW, boolean leftHeaded, short dist) {
        Map<IntDependency, IntDependency> map = this.expandDependencyMap;
        if (this.internTempDependency == null) {
            this.internTempDependency = new IntDependency();
        }
        this.internTempDependency.head = (IntTaggedWord)Interner.globalIntern(headTW);
        this.internTempDependency.arg = (IntTaggedWord)Interner.globalIntern(argTW);
        this.internTempDependency.leftHeaded = leftHeaded;
        this.internTempDependency.distance = dist;
        IntDependency returnDependency = this.internTempDependency;
        if (map != null && (returnDependency = map.get(this.internTempDependency)) == null) {
            map.put(this.internTempDependency, this.internTempDependency);
            returnDependency = this.internTempDependency;
        }
        if (returnDependency == this.internTempDependency) {
            this.internTempDependency = null;
        }
        return returnDependency;
    }

    static {
        stopTW = new IntTaggedWord(-2, -2);
        wildTW = new IntTaggedWord(-1, -1);
    }
}

