/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import java.util.HashSet;
import java.util.Set;

class BinaryGrammarExtractor
extends AbstractTreeExtractor {
    protected Numberer stateNumberer = Numberer.getGlobalNumberer("states");
    private Counter<Rule> ruleCounter = new Counter();
    private Counter symbolCounter = new Counter();
    private Set<Rule> binaryRules = new HashSet<Rule>();
    private Set<Rule> unaryRules = new HashSet<Rule>();

    BinaryGrammarExtractor() {
    }

    protected void tallyRule(Rule r, double score) {
        this.symbolCounter.incrementCount(this.stateNumberer.object(r.parent), score);
        this.ruleCounter.incrementCount(r, score);
        if (r.isUnary()) {
            this.unaryRules.add(r);
        } else {
            this.binaryRules.add(r);
        }
    }

    protected void tallyInternalNode(Tree lt) {
        Rule r = null;
        if (lt.children().length == 1) {
            UnaryRule ur = new UnaryRule();
            ur.parent = this.stateNumberer.number(lt.label().value());
            ur.child = this.stateNumberer.number(lt.children()[0].label().value());
            r = ur;
        } else {
            BinaryRule br = new BinaryRule();
            br.parent = this.stateNumberer.number(lt.label().value());
            br.leftChild = this.stateNumberer.number(lt.children()[0].label().value());
            br.rightChild = this.stateNumberer.number(lt.children()[1].label().value());
            r = br;
        }
        this.tallyRule(r, this.weight);
    }

    protected Object formResult() {
        this.stateNumberer.number(".$$.");
        BinaryGrammar bg = new BinaryGrammar(this.stateNumberer.total());
        UnaryGrammar ug = new UnaryGrammar(this.stateNumberer.total());
        for (UnaryRule unaryRule : this.unaryRules) {
            unaryRule.score = (float)Math.log(this.ruleCounter.getCount(unaryRule) / this.symbolCounter.getCount(this.stateNumberer.object(unaryRule.parent)));
            if (Train.compactGrammar() >= 4) {
                unaryRule.score = (float)this.ruleCounter.getCount(unaryRule);
            }
            ug.addRule(unaryRule);
        }
        for (BinaryRule binaryRule : this.binaryRules) {
            binaryRule.score = (float)Math.log((this.ruleCounter.getCount(binaryRule) - Train.ruleDiscount) / this.symbolCounter.getCount(this.stateNumberer.object(binaryRule.parent)));
            if (Train.compactGrammar() >= 4) {
                binaryRule.score = (float)this.ruleCounter.getCount(binaryRule);
            }
            bg.addRule(binaryRule);
        }
        return new Pair<UnaryGrammar, BinaryGrammar>(ug, bg);
    }
}

