/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class ExtractorLastVerbalTC
extends Extractor {
    static int commThat = 0;
    private static final String thatWord = TestSentence.toSt("that");
    private static final String inTag = TestSentence.toSt("IN");
    private static final String wdtTag = TestSentence.toSt("WDT");
    private static final String dtTag = TestSentence.toSt("DT");
    static int[][] counts = new int[3][3];
    private static final long serialVersionUID = -2324821292516788746L;

    public boolean Precondition(String tag) {
        return true;
    }

    public static void printCounts() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                System.out.print(String.valueOf(counts[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        if (!cword.equals(thatWord)) {
            return "0";
        }
        GlobalHolder.pairs.get(h, 0, true);
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        String tag = "NA";
        while (index >= start) {
            tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            --index;
        }
        if (lastverb.startsWith("NA")) {
            return "3";
        }
        if (this.isThatComplTakingVerb(lastverb, tag)) {
            return "1";
        }
        return "2";
    }

    String extract(History h, int bound) {
        String cword = ExtractorFrames.cWord.extract(h);
        if (!cword.equals(thatWord)) {
            return "0";
        }
        String lastverb = this.extractLV(h);
        if (lastverb.startsWith("NA")) {
            return "0";
        }
        if (this.isThatComplTakingVerb(lastverb, bound)) {
            return "1";
        }
        return "2";
    }

    String extractLV(History h) {
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        while (index >= start) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            if (tag.startsWith(",")) break;
            --index;
        }
        return lastverb;
    }

    boolean isThatComplTakingVerb(String verb, String tag) {
        int i;
        if (GlobalHolder.dict.sum(verb) == 0 && (i = (int)(Math.random() * 2.0)) == 0) {
            GlobalHolder.dict.addVThatTaking(verb);
            return true;
        }
        return GlobalHolder.dict.getCountThat(verb) > commThat;
    }

    boolean isThatComplTakingVerb(String verb, int bound) {
        return GlobalHolder.dict.getCountThat(verb) > bound;
    }
}

