/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.tagger.maxent.CollectionTaggerOutputs;
import edu.stanford.nlp.tagger.maxent.DataWordTag;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.ReadDataTagged;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TemplateHash;
import edu.stanford.nlp.util.Pair;
import java.io.RandomAccessFile;

public class TaggerExperiments
extends Experiments {
    static TaggerFeatures feats = new TaggerFeatures();
    static double sigmas;
    static String zeroSt;
    private int numFeatsGeneral = GlobalHolder.extractors.getSize();
    private int numFeatsAll = this.numFeatsGeneral + GlobalHolder.extractorsRare.getSize();

    static {
        zeroSt = "0";
    }

    public TaggerExperiments() throws Exception {
    }

    public TaggerExperiments(String filename, String[] args_outputs, String delimiter) throws Exception {
        System.out.println("entering experiments: adding word/tags");
        ReadDataTagged c = new ReadDataTagged(filename, delimiter);
        vArray = new int[c.getSize()][2];
        number = c.getSize();
        System.out.println("general features " + this.numFeatsGeneral + " all " + this.numFeatsAll);
        System.err.println("================================");
        this.initTemplatesNew();
        this.initHistoryNew();
        if (args_outputs != null) {
            GlobalHolder.collectionTaggers = new CollectionTaggerOutputs(args_outputs);
        }
        int i = 0;
        int size = c.getSize();
        while (i < size) {
            DataWordTag d = c.get(i);
            String yS = d.getY();
            History h = d.getHistory();
            int indX = GlobalHolder.tHistories.add(h);
            int indY = d.getYInd();
            this.addTemplatesNew(h, yS, indX, indY);
            this.addRareTemplatesNew(h, yS, indX, indY);
            TaggerExperiments.vArray[i][0] = indX;
            TaggerExperiments.vArray[i][1] = indY;
            if (i % 10000 == 0) {
                System.out.println(i);
            }
            ++i;
        }
        System.out.println(" before release ");
        c.release();
        System.out.println(" after release ");
        this.ptilde();
        GlobalHolder.xSize = xSize;
        GlobalHolder.ySize = ySize;
        this.hashHistories();
        System.out.println(" end hash histories ");
        if (!GlobalHolder.occuringTagsOnly) {
            GlobalHolder.tHistories.release();
            GlobalHolder.pairs.release();
        }
        System.out.println(" end ptilde ");
        this.getFeaturesNew();
        System.out.println(" end get features ");
    }

    public void initHistory() {
    }

    public void initHistoryNew() {
    }

    public void updateHistory() {
    }

    public void getFeaturesNew() {
        boolean VERBOSE = false;
        try {
            int y;
            GlobalHolder.fnumArr = new byte[xSize][ySize];
            System.out.println(" fnum arr initialized ");
            RandomAccessFile hF = new RandomAccessFile("temp.x", "rw");
            Object[] arr = GlobalHolder.sTemplates.toArray();
            System.out.println(" length of keys " + arr.length);
            int current = 0;
            int numFeats = 0;
            int i = 0;
            while (i < arr.length) {
                FeatureKey fK = (FeatureKey)arr[i];
                int numF = fK.num;
                Pair<Integer, String> wT = new Pair<Integer, String>(new Integer(numF), fK.val);
                int[] xValues = GlobalHolder.tFeature.getXValues(wT);
                if (xValues == null) {
                    System.out.println(" xValues is null " + fK.toString() + " " + i);
                } else {
                    int numEvidence = 0;
                    y = GlobalHolder.tags.getIndex(fK.tag);
                    int q = 0;
                    while (q < xValues.length) {
                        String word;
                        if (!GlobalHolder.occuringTagsOnly || GlobalHolder.dict.getCount(word = ExtractorFrames.cWord.extract(GlobalHolder.tHistories.getHistory(xValues[q])), fK.tag) != 0) {
                            numEvidence += this.px[xValues[q]];
                        }
                        ++q;
                    }
                    if (TaggerExperiments.populated(numF, numEvidence)) {
                        int[] positions = GlobalHolder.tFeature.getPositions(fK);
                        if (GlobalHolder.occuringTagsOnly) {
                            positions = null;
                        }
                        if (positions == null) {
                            int numElements = 0;
                            int j = 0;
                            while (j < xValues.length) {
                                String word;
                                int x = xValues[j];
                                if (!GlobalHolder.occuringTagsOnly || GlobalHolder.dict.getCount(word = ExtractorFrames.cWord.extract(GlobalHolder.tHistories.getHistory(x)), fK.tag) != 0) {
                                    ++numElements;
                                    hF.writeInt(x);
                                    byte[] byArray = GlobalHolder.fnumArr[x];
                                    int n = y;
                                    byArray[n] = (byte)(byArray[n] + 1);
                                }
                                ++j;
                            }
                            TaggerFeature tF = new TaggerFeature(current, current + numElements - 1, fK);
                            GlobalHolder.tFeature.addPositions(current, current + numElements - 1, fK);
                            current += numElements;
                            feats.add(tF);
                            if (VERBOSE) {
                                System.out.println("added feature with key " + fK.toString() + " has support " + numElements);
                            }
                        } else {
                            int j = 0;
                            while (j < xValues.length) {
                                int x = xValues[j];
                                byte[] byArray = GlobalHolder.fnumArr[x];
                                int n = y;
                                byArray[n] = (byte)(byArray[n] + 1);
                                ++j;
                            }
                            TaggerFeature tF = new TaggerFeature(positions[0], positions[1], fK);
                            feats.add(tF);
                            if (VERBOSE) {
                                System.out.println("added feature with key " + fK.toString() + " has support " + xValues.length);
                            }
                        }
                        GlobalHolder.putAssoc(fK, numFeats);
                        ++numFeats;
                    }
                    if (i % 10000 == 0) {
                        System.out.println(" feats" + i);
                    }
                }
                ++i;
            }
            GlobalHolder.tFeature.release();
            System.gc();
            TaggerFeatures.xIndexed = new int[current];
            hF.seek(0L);
            int current1 = 0;
            while (current1 < current) {
                TaggerFeatures.xIndexed[current1] = hF.readInt();
                ++current1;
            }
            System.out.println(" total " + arr.length + " populates " + numFeats);
            hF.close();
            byte max = 0;
            int maxGt = 0;
            int numZeros = 0;
            int x = 0;
            while (x < xSize) {
                int numGt = 0;
                y = 0;
                while (y < ySize) {
                    if (GlobalHolder.fnumArr[x][y] > 0) {
                        ++numGt;
                        if (max < GlobalHolder.fnumArr[x][y]) {
                            max = GlobalHolder.fnumArr[x][y];
                        }
                    } else {
                        ++numZeros;
                    }
                    ++y;
                }
                if (maxGt < numGt) {
                    maxGt = numGt;
                }
                ++x;
            }
            System.out.println(String.valueOf(max) + " " + maxGt + " zeros " + numZeros);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hashHistories() {
        int i;
        int fSize;
        History h;
        int fAll = GlobalHolder.extractors.getSize() + GlobalHolder.extractorsRare.getSize();
        int fGeneral = GlobalHolder.extractors.getSize();
        System.out.println("Hashing histories");
        int x = 0;
        while (x < xSize) {
            h = GlobalHolder.tHistories.getHistory(x);
            if (x % 10000 == 0) {
                System.out.println(x);
            }
            fSize = GlobalHolder.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            i = 0;
            while (i < fSize) {
                GlobalHolder.tFeature.addPrev(i, h, x);
                ++i;
            }
            ++x;
        }
        System.out.println("Hashing populated histories");
        x = 0;
        while (x < xSize) {
            h = GlobalHolder.tHistories.getHistory(x);
            if (x % 10000 == 0) {
                System.out.println(x);
            }
            fSize = GlobalHolder.isRare(ExtractorFrames.cWord.extract(h)) ? fAll : fGeneral;
            i = 0;
            while (i < fSize) {
                GlobalHolder.tFeature.add(i, h, x);
                ++i;
            }
            ++x;
        }
    }

    public void hashHistories(TemplateHash tFeats, int fNo) {
        int cfr_ignored_0 = GlobalHolder.extractors.getSize() + GlobalHolder.extractorsRare.getSize();
        GlobalHolder.extractors.getSize();
        int x = 0;
        while (x < xSize) {
            History h = GlobalHolder.tHistories.getHistory(x);
            tFeats.add(fNo, h, x);
            ++x;
        }
    }

    public static boolean populated(int fNo, int size) {
        if (fNo == 0) {
            return size > GlobalHolder.tresholdCW;
        }
        if (fNo < GlobalHolder.extractors.getSize()) {
            return size > GlobalHolder.threshold;
        }
        return size > GlobalHolder.thresholdRare;
    }

    public void initTemplates() {
    }

    public void initTemplatesNew() {
        GlobalHolder.tFeature.init();
        GlobalHolder.dict.setAmbClasses();
    }

    public void addTemplatesNew(History h, String tag, int x, int y) {
        int i = 0;
        while (i < this.numFeatsGeneral) {
            String s = GlobalHolder.extractors.extract(i, h);
            if (!s.equals(zeroSt)) {
                if (GlobalHolder.alltags) {
                    int numTags = GlobalHolder.tags.getSize();
                    int j = 0;
                    while (j < numTags) {
                        String tag1 = GlobalHolder.tags.getTag(j);
                        FeatureKey key = new FeatureKey(i, s, tag1);
                        if (GlobalHolder.extractors.get(i).Precondition(tag1)) {
                            GlobalHolder.add(key);
                        }
                        ++j;
                    }
                } else {
                    FeatureKey key = new FeatureKey(i, s, tag);
                    if (GlobalHolder.extractors.get(i).Precondition(tag)) {
                        GlobalHolder.add(key);
                    }
                }
            }
            ++i;
        }
    }

    public void addRareTemplatesNew(History h, String tag, int x, int y) {
        int start;
        if (!GlobalHolder.isRare(ExtractorFrames.cWord.extract(h))) {
            return;
        }
        int i = start = this.numFeatsGeneral;
        while (i < this.numFeatsAll) {
            String s = GlobalHolder.extractorsRare.extract(i - start, h);
            if (!s.equals(zeroSt)) {
                if (GlobalHolder.alltags) {
                    int numTags = GlobalHolder.tags.getSize();
                    int j = 0;
                    while (j < numTags) {
                        String tag1 = GlobalHolder.tags.getTag(j);
                        FeatureKey key = new FeatureKey(i, s, tag1);
                        if (GlobalHolder.extractorsRare.get(i - start).Precondition(tag1)) {
                            GlobalHolder.add(key);
                        }
                        ++j;
                    }
                } else {
                    FeatureKey key = new FeatureKey(i, s, tag);
                    if (GlobalHolder.extractorsRare.get(i - start).Precondition(tag)) {
                        GlobalHolder.add(key);
                    }
                }
            }
            ++i;
        }
    }

    public String getY(int index) {
        return GlobalHolder.tags.getTag(vArray[index][1]);
    }

    public static void main(String[] args) {
    }
}

