/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreebankLanguagePack
implements TreebankLanguagePack,
Serializable {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final Filter<String> punctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationTags());
    private final Filter<String> punctWordStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationWords());
    private final Filter<String> sFPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.sentenceFinalPunctuationTags());
    private final Filter<String> eIPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.evalBIgnoredPunctuationTags());
    private final Filter<String> startSymbolAcceptFilter = Filters.collectionAcceptFilter(this.startSymbols());
    private static final long serialVersionUID = -6506749780512708352L;

    @Override
    public abstract String[] punctuationTags();

    @Override
    public abstract String[] punctuationWords();

    @Override
    public abstract String[] sentenceFinalPunctuationTags();

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return this.punctuationTags();
    }

    @Override
    public boolean isPunctuationTag(String str) {
        return this.punctTagStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isPunctuationWord(String str) {
        return this.punctWordStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isSentenceFinalPunctuationTag(String str) {
        return this.sFPunctTagStringAcceptFilter.accept(str);
    }

    @Override
    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return this.eIPunctTagStringAcceptFilter.accept(str);
    }

    @Override
    public Filter<String> punctuationTagAcceptFilter() {
        return this.punctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> punctuationTagRejectFilter() {
        return Filters.notFilter(this.punctTagStringAcceptFilter);
    }

    @Override
    public Filter<String> punctuationWordAcceptFilter() {
        return this.punctWordStringAcceptFilter;
    }

    @Override
    public Filter<String> punctuationWordRejectFilter() {
        return Filters.notFilter(this.punctWordStringAcceptFilter);
    }

    @Override
    public Filter<String> sentenceFinalPunctuationTagAcceptFilter() {
        return this.sFPunctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> evalBIgnoredPunctuationTagAcceptFilter() {
        return this.eIPunctTagStringAcceptFilter;
    }

    @Override
    public Filter<String> evalBIgnoredPunctuationTagRejectFilter() {
        return Filters.notFilter(this.eIPunctTagStringAcceptFilter);
    }

    @Override
    public String getEncoding() {
        return DEFAULT_ENCODING;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return new char[0];
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        char seenAtZero = '\u0000';
        int leng = category.length();
        for (i = 0; i < leng; ++i) {
            char ch = category.charAt(i);
            if (!this.isLabelAnnotationIntroducingCharacter(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    @Override
    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        return category.substring(0, this.postBasicCategoryIndex(category));
    }

    @Override
    public Function<String, String> getBasicCategoryFunction() {
        return new Function(){

            public Object apply(Object in) {
                if (!(in instanceof String)) {
                    return null;
                }
                String s = (String)in;
                return AbstractTreebankLanguagePack.this.basicCategory(s);
            }
        };
    }

    @Override
    public String categoryAndFunction(String category) {
        if (category == null) {
            return null;
        }
        String catFunc = category.substring(0);
        int i = this.lastIndexOfNumericTag(catFunc);
        while (i >= 0) {
            catFunc = catFunc.substring(0, i);
            i = this.lastIndexOfNumericTag(catFunc);
        }
        return catFunc;
    }

    private int lastIndexOfNumericTag(String category) {
        if (category == null) {
            return -1;
        }
        int last = -1;
        for (int i = category.length() - 1; i >= 0; --i) {
            if (!this.isLabelAnnotationIntroducingCharacter(category.charAt(i))) continue;
            boolean onlyDigitsFollow = false;
            for (int j = i + 1; j < category.length(); ++j) {
                onlyDigitsFollow = true;
                if (Character.isDigit(category.charAt(j))) continue;
                onlyDigitsFollow = false;
                break;
            }
            if (!onlyDigitsFollow) continue;
            last = i;
        }
        return last;
    }

    @Override
    public Function<String, String> getCategoryAndFunctionFunction() {
        return new Function(){

            public Object apply(Object in) {
                if (!(in instanceof String)) {
                    return null;
                }
                String s = (String)in;
                return AbstractTreebankLanguagePack.this.categoryAndFunction(s);
            }
        };
    }

    @Override
    public boolean isLabelAnnotationIntroducingCharacter(char ch) {
        char[] cutChars = this.labelAnnotationIntroducingCharacters();
        for (int i = 0; i < cutChars.length; ++i) {
            if (ch != cutChars[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartSymbol(String str) {
        return this.startSymbolAcceptFilter.accept(str);
    }

    @Override
    public Filter<String> startSymbolAcceptFilter() {
        return this.startSymbolAcceptFilter;
    }

    @Override
    public abstract String[] startSymbols();

    @Override
    public String startSymbol() {
        String[] ssyms = this.startSymbols();
        if (ssyms == null || ssyms.length == 0) {
            return null;
        }
        return ssyms[0];
    }

    @Override
    public TokenizerFactory getTokenizerFactory() {
        return WhitespaceTokenizer.factory(false);
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        throw new UnsupportedOperationException("No GrammaticalStructureFactory defined for " + this.getClass().getName());
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilt) {
        return this.grammaticalStructureFactory();
    }
}

