/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGraph
implements Serializable {
    protected TreeGraphNode root;
    private Map<Integer, TreeGraphNode> indexMap = new HashMap<Integer, TreeGraphNode>();
    private static final long serialVersionUID = 1L;

    public TreeGraph(Tree t) {
        this.root = new TreeGraphNode(t, (TreeGraphNode)null);
        this.root.setTreeGraph(this);
        this.root.indexNodes();
    }

    public TreeGraphNode root() {
        return this.root;
    }

    public void addNodeToIndexMap(int index, TreeGraphNode node) {
        this.indexMap.put(new Integer(index), node);
    }

    public TreeGraphNode getNodeByIndex(int index) {
        return this.indexMap.get(new Integer(index));
    }

    public Collection<TreeGraphNode> getNodes() {
        return this.indexMap.values();
    }

    public String toString() {
        return this.root.toPrettyString(0).substring(1);
    }

    public static void main(String[] args) {
        Tree t;
        try {
            t = Tree.valueOf("(S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today))))");
        }
        catch (Exception e) {
            System.err.println("Horrible error: " + e);
            e.printStackTrace();
            return;
        }
        t.pennPrint();
        System.out.println("----------------------------");
        TreeGraph tg = new TreeGraph(t);
        System.out.println(tg);
        tg.root.percolateHeads(new SemanticHeadFinder());
        System.out.println("----------------------------");
        System.out.println(tg);
        TreeGraphNode node1 = tg.getNodeByIndex(1);
        TreeGraphNode node4 = tg.getNodeByIndex(4);
        node1.addArc("1to4", node4);
        node1.addArc("1TO4", node4);
        node4.addArc("4to1", node1);
        System.out.println("----------------------------");
        System.out.println("arcs from 1 to 4: " + node1.arcLabelsToNode(node4));
        System.out.println("arcs from 4 to 1: " + node4.arcLabelsToNode(node1));
        System.out.println("arcs from 0 to 4: " + tg.root.arcLabelsToNode(node4));
        for (int i = 0; i <= 9; ++i) {
            System.out.println("parent of " + i + ": " + tg.getNodeByIndex(i).parent());
            System.out.println("highest node with same head as " + i + ": " + tg.getNodeByIndex(i).highestNodeWithSameHead());
        }
    }
}

