/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import java.io.Serializable;

public class NegraPennLanguagePack
extends AbstractTreebankLanguagePack
implements Serializable {
    private static final String NEGRA_ENCODING = "ISO-8859-1";
    private static final String[] evalBignoredTags = new String[]{"$.", "$,"};
    private static final String[] negraSFPunctTags = new String[]{"$."};
    private static final String[] negraSFPunctWords = new String[]{".", "!", "?"};
    private static final String[] negraPunctTags = new String[]{"$.", "$,", "$*LRB*"};
    private static final String[] negraPunctWords = new String[]{"-", ",", ";", ":", "!", "?", "/", ".", "...", "\u00b7", "'", "\"", "(", ")"};
    private static char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
    private static String[] pennStartSymbols = new String[]{"ROOT"};
    private static final long serialVersionUID = 9081305982861675328L;

    public String[] punctuationTags() {
        return negraPunctTags;
    }

    public String[] punctuationWords() {
        return negraPunctWords;
    }

    public String[] sentenceFinalPunctuationTags() {
        return negraSFPunctTags;
    }

    public String[] sentenceFinalPunctuationWords() {
        return negraSFPunctWords;
    }

    public String[] evalBIgnoredPunctuationTags() {
        return evalBignoredTags;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public String getEncoding() {
        return NEGRA_ENCODING;
    }

    public String treebankFileExtension() {
        return "mrg";
    }

    public static void main(String[] args) {
    }
}

