/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;

class AdjoinNode
extends TsurgeonPattern {
    AuxiliaryTree adjunctionTree;

    public AdjoinNode(AuxiliaryTree t, TsurgeonPattern p) {
        super("adjoin", new TsurgeonPattern[]{p});
        this.adjunctionTree = t;
    }

    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree targetNode = this.children[0].evaluate(t, m);
        Tree parent = targetNode.parent(t);
        AuxiliaryTree ft = this.adjunctionTree.copy(this);
        ft.foot.setChildren(targetNode.getChildrenAsList());
        if (parent == null) {
            return ft.tree;
        }
        int i = parent.indexOf(targetNode);
        parent.setChild(i, ft.tree);
        return t;
    }

    public String toString() {
        return super.toString() + "<-" + this.adjunctionTree.toString();
    }
}

