/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TreeMatcher;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParser;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tsurgeon {
    static boolean verbose = false;
    static Pattern emptyLinePattern = Pattern.compile("^\\s*$");
    static String commentIntroducingCharacter = "%";
    static Pattern commentPattern = Pattern.compile(commentIntroducingCharacter + ".*$");
    static Pattern escapedCommentCharacterPattern = Pattern.compile("\\" + commentIntroducingCharacter);
    private static boolean matchedOnTree = false;

    public static void main(String[] args) throws Exception {
        String encoding = "UTF-8";
        String encodingOption = "-encoding";
        if (args.length == 0) {
            System.err.println("Usage: java edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon [-s] -treeFile <file-with-trees> [-po <matching-pattern> <operation>] <operation-file-1> <operation-file-1> ... <operation-file-n>");
            System.exit(0);
        }
        String treePrintFormats = "";
        String singleLineOption = "-s";
        String verboseOption = "-v";
        String matchedOption = "-m";
        String patternOperationOption = "-po";
        String treeFileOption = "-treeFile";
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put(patternOperationOption, 2);
        flagMap.put(treeFileOption, 1);
        flagMap.put(singleLineOption, 0);
        flagMap.put(encodingOption, 1);
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, flagMap);
        args = argsMap.get(null);
        if (argsMap.containsKey(verboseOption)) {
            verbose = true;
        }
        treePrintFormats = argsMap.containsKey(singleLineOption) ? treePrintFormats + "oneline," : treePrintFormats + "penn,";
        if (argsMap.containsKey(encodingOption)) {
            encoding = argsMap.get(encodingOption)[0];
        }
        TreePrint tp = new TreePrint(treePrintFormats, new PennTreebankLanguagePack());
        PrintWriter pwOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
        tp.setPrintWriter(pwOut);
        DiskTreebank trees = new DiskTreebank(new TreeMatcher.TRegexTreeReaderFactory(), encoding);
        if (argsMap.containsKey(treeFileOption)) {
            trees.loadPath(argsMap.get(treeFileOption)[0]);
        }
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        if (argsMap.containsKey(patternOperationOption)) {
            TregexPattern matchPattern = TregexPattern.compile(argsMap.get(patternOperationOption)[0]);
            TsurgeonPattern p = Tsurgeon.parseOperation(argsMap.get(patternOperationOption)[1]);
            ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
        } else {
            for (String arg : args) {
                Pair<TregexPattern, TsurgeonPattern> pair = Tsurgeon.getOperationFromFile(arg);
                if (verbose) {
                    System.err.println(pair.second());
                }
                ops.add(pair);
            }
        }
        for (Tree t : trees) {
            Tree original = t.deeperCopy();
            Tree result = Tsurgeon.processPatternsOnTree(ops, t);
            if (argsMap.containsKey(matchedOption) && matchedOnTree) {
                pwOut.println("Operated on: ");
                Tsurgeon.disposeOfTree(original, tp, pwOut);
                pwOut.println("Result: ");
            }
            Tsurgeon.disposeOfTree(result, tp, pwOut);
        }
    }

    private static void disposeOfTree(Tree t, TreePrint tp, PrintWriter pw) {
        if (t == null) {
            System.out.println("null");
        } else {
            tp.printTree(t, pw);
        }
    }

    public static Pair<TregexPattern, TsurgeonPattern> getOperationFromFile(String arg) throws IOException {
        TregexPattern matchPattern = null;
        BufferedReader r = new BufferedReader(new FileReader(arg));
        String matchString = "";
        String thisLine = null;
        while ((thisLine = r.readLine()) != null && !emptyLinePattern.matcher(thisLine).matches()) {
            matchString = matchString + thisLine;
        }
        try {
            matchPattern = TregexPattern.compile(matchString);
        }
        catch (ParseException e) {
            System.err.println("Error parsing your tregex pattern:\n" + matchString);
            throw new RuntimeException();
        }
        ArrayList<TsurgeonPattern> ps = new ArrayList<TsurgeonPattern>();
        while ((thisLine = r.readLine()) != null) {
            Matcher m = commentPattern.matcher(thisLine);
            thisLine = m.replaceFirst("");
            Matcher m1 = escapedCommentCharacterPattern.matcher(thisLine);
            if (emptyLinePattern.matcher(thisLine = m1.replaceAll(commentIntroducingCharacter)).matches()) continue;
            try {
                ps.add(TsurgeonParser.parse(thisLine));
            }
            catch (edu.stanford.nlp.trees.tregex.tsurgeon.ParseException e) {
                System.err.println("Error parsing your tsurgeon operation:\n" + thisLine);
                throw new RuntimeException(e.toString());
            }
        }
        TsurgeonPattern collectedPattern = Tsurgeon.collectOperations(ps);
        Pair<TregexPattern, TsurgeonPattern> pair = new Pair<TregexPattern, TsurgeonPattern>(matchPattern, collectedPattern);
        return pair;
    }

    public static Collection<Tree> processPatternOnTrees(TregexPattern matchPattern, TsurgeonPattern p, Collection<Tree> inputTrees) {
        ArrayList<Tree> result = new ArrayList<Tree>();
        for (Tree tree : inputTrees) {
            result.add(Tsurgeon.processPattern(matchPattern, p, tree));
        }
        return result;
    }

    public static Tree processPattern(TregexPattern matchPattern, TsurgeonPattern p, Tree t) {
        TregexMatcher m = matchPattern.matcher(t);
        while (m.find() && (t = p.evaluate(t, m)) != null) {
            m = matchPattern.matcher(t);
        }
        return t;
    }

    public static Tree processPatternsOnTree(List<Pair<TregexPattern, TsurgeonPattern>> ops, Tree t) {
        matchedOnTree = false;
        for (Pair<TregexPattern, TsurgeonPattern> op : ops) {
            TregexMatcher m = op.first().matcher(t);
            while (m.find()) {
                matchedOnTree = true;
                Tree result = op.second().evaluate(t, m);
                if (result == null) {
                    return null;
                }
                m = op.first().matcher(t);
            }
        }
        return t;
    }

    public static TsurgeonPattern parseOperation(String operationString) {
        try {
            return new TsurgeonPatternRoot(new TsurgeonPattern[]{TsurgeonParser.parse(operationString)});
        }
        catch (edu.stanford.nlp.trees.tregex.tsurgeon.ParseException e) {
            throw new IllegalArgumentException("Ill-formed operation string: " + operationString);
        }
    }

    public static TsurgeonPattern collectOperations(List<TsurgeonPattern> patterns) {
        return new TsurgeonPatternRoot(patterns.toArray(new TsurgeonPattern[0]));
    }
}

