/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.browser.AbstractWorkbenchBrowserSupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.ExternalBrowserInstance;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.InternalBrowserEditorInstance;
import org.eclipse.ui.internal.browser.InternalBrowserInstance;
import org.eclipse.ui.internal.browser.InternalBrowserViewInstance;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.SystemBrowserDescriptor;
import org.eclipse.ui.internal.browser.SystemBrowserInstance;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class DefaultBrowserSupport
extends AbstractWorkbenchBrowserSupport {
    static final String SHARED_ID = "org.eclipse.ui.browser";
    static final String DEFAULT_ID_BASE = "org.eclipse.ui.defaultBrowser";
    protected HashMap browserIdMap = new HashMap();
    protected static DefaultBrowserSupport instance;

    public DefaultBrowserSupport() {
        instance = this;
        BrowserManager.getInstance().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                DefaultBrowserSupport.this.browserIdMap.clear();
            }
        });
    }

    protected static DefaultBrowserSupport getInstance() {
        return instance;
    }

    protected IWebBrowser getExistingWebBrowser(String browserId) {
        try {
            Object obj = this.browserIdMap.get(browserId);
            IWebBrowser browser = null;
            if (obj instanceof IWebBrowser) {
                browser = (IWebBrowser)obj;
            } else if (obj instanceof HashMap) {
                HashMap wmap = (HashMap)obj;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    browser = (IWebBrowser)wmap.get(this.getWindowKey(window));
                }
            }
            if (browser != null) {
                return browser;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Integer getWindowKey(IWorkbenchWindow window) {
        return new Integer(window.hashCode());
    }

    public IWebBrowser createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        IWebBrowser browser;
        if (browserId == null) {
            browserId = this.getDefaultId();
        }
        if ((browser = this.getExistingWebBrowser(browserId)) != null) {
            if (browser instanceof InternalBrowserInstance) {
                InternalBrowserInstance instance2 = (InternalBrowserInstance)browser;
                instance2.setName(name);
                instance2.setTooltip(tooltip);
            }
            return browser;
        }
        AbstractWebBrowser webBrowser = null;
        if ((style & 0x80) != 0 || WebBrowserPreference.getBrowserChoice() != 0) {
            IBrowserDescriptor ewb = BrowserManager.getInstance().getCurrentWebBrowser();
            if (ewb == null) {
                throw new PartInitException(Messages.errorNoBrowser);
            }
            if (ewb instanceof SystemBrowserDescriptor) {
                webBrowser = new SystemBrowserInstance(browserId);
            } else {
                IBrowserExt ext = null;
                if (ewb != null) {
                    ext = WebBrowserUIPlugin.findBrowsers(ewb.getLocation());
                }
                if (ext != null) {
                    webBrowser = ext.createBrowser(browserId, ewb.getLocation(), ewb.getParameters());
                }
                if (webBrowser == null) {
                    webBrowser = new ExternalBrowserInstance(browserId, ewb);
                }
            }
        } else {
            webBrowser = (style & 0x40) != 0 ? new InternalBrowserViewInstance(browserId, style, name, tooltip) : new InternalBrowserEditorInstance(browserId, style, name, tooltip);
        }
        if (webBrowser instanceof InternalBrowserInstance) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Integer key = this.getWindowKey(window);
            HashMap<Integer, AbstractWebBrowser> wmap = (HashMap<Integer, AbstractWebBrowser>)this.browserIdMap.get(browserId);
            if (wmap == null) {
                wmap = new HashMap<Integer, AbstractWebBrowser>();
                this.browserIdMap.put(browserId, wmap);
            }
            wmap.put(key, webBrowser);
        } else {
            this.browserIdMap.put(browserId, webBrowser);
        }
        return webBrowser;
    }

    public IWebBrowser createBrowser(String browserId) throws PartInitException {
        return this.createBrowser(0, browserId, null, null);
    }

    public boolean isInternalWebBrowserAvailable() {
        return WebBrowserUtil.canUseInternalWebBrowser();
    }

    protected void removeBrowser(IWebBrowser browser) {
        String baseId = WebBrowserUtil.decodeId(browser.getId());
        if (browser instanceof InternalBrowserInstance) {
            Integer key = ((InternalBrowserInstance)browser).getWindowKey();
            HashMap wmap = (HashMap)this.browserIdMap.get(baseId);
            if (wmap != null) {
                wmap.remove(key);
                if (wmap.isEmpty()) {
                    this.browserIdMap.remove(baseId);
                }
            }
        } else {
            this.browserIdMap.remove(baseId);
        }
    }

    private String getDefaultId() {
        String id = null;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            id = DEFAULT_ID_BASE + i;
            if (this.browserIdMap.get(id) == null) break;
            ++i;
        }
        return id;
    }
}

