/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi;

import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemCache {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int DEFAULT_MAXIMUM_CAPACITY = 500;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    boolean fCachingEnabled = true;
    int fInitialCapacity;
    int fMaximumCapacity;
    protected Map<IIndexWordID, IIndexWord> indexCache;
    protected Map<IWordID, IWord> wordCache;
    protected Map<ISenseKey, IWord> keyCache;
    protected Map<ISynsetID, ISynset> synsetCache;
    protected Map<IExceptionEntryID, IExceptionEntry> entryCache;
    protected Map<ISenseKey, ISenseEntry> senseCache;

    public ItemCache() {
        this(16, 500, true);
    }

    public ItemCache(int initialCapacity, int maxCapacity, boolean enabled) {
        this.setInitialCapacity(initialCapacity);
        this.setMaximumCapacity(maxCapacity);
        this.setCachingEnabled(enabled);
    }

    public void init() {
        this.clear();
        if (this.fInitialCapacity < 0) {
            this.indexCache = this.makeCache();
            this.wordCache = this.makeCache();
            this.keyCache = this.makeCache();
            this.synsetCache = this.makeCache();
            this.entryCache = this.makeCache();
            this.senseCache = this.makeCache();
        } else {
            this.indexCache = this.makeCache(this.fInitialCapacity);
            this.wordCache = this.makeCache(this.fInitialCapacity);
            this.keyCache = this.makeCache(this.fInitialCapacity);
            this.synsetCache = this.makeCache(this.fInitialCapacity);
            this.entryCache = this.makeCache(this.fInitialCapacity);
            this.senseCache = this.makeCache(this.fInitialCapacity);
        }
    }

    protected <K, V> Map<K, V> makeCache() {
        return this.makeCache(16);
    }

    protected <K, V> Map<K, V> makeCache(int initialCapacity) {
        LinkedHashMap map = new LinkedHashMap(16, 0.75f, true);
        return Collections.synchronizedMap(map);
    }

    public void clear() {
        if (this.indexCache != null) {
            this.indexCache.clear();
        }
        if (this.wordCache != null) {
            this.wordCache.clear();
        }
        if (this.keyCache != null) {
            this.keyCache.clear();
        }
        if (this.synsetCache != null) {
            this.synsetCache.clear();
        }
        if (this.entryCache != null) {
            this.entryCache.clear();
        }
        if (this.senseCache != null) {
            this.senseCache.clear();
        }
    }

    public boolean isCachingEnabled() {
        return this.fCachingEnabled;
    }

    public int getInitialCapacity() {
        return this.fInitialCapacity;
    }

    public int getMaximumCapacity() {
        return this.fMaximumCapacity;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.fCachingEnabled = cachingEnabled;
    }

    public void setInitialCapacity(int capacity) {
        this.fInitialCapacity = capacity;
    }

    public void setMaximumCapacity(int capacity) {
        int oldCapacity = this.fMaximumCapacity;
        this.fMaximumCapacity = capacity;
        if (this.fMaximumCapacity < 0 || oldCapacity <= this.fMaximumCapacity) {
            return;
        }
        this.reduceCacheSize(this.indexCache);
        this.reduceCacheSize(this.wordCache);
        this.reduceCacheSize(this.keyCache);
        this.reduceCacheSize(this.synsetCache);
        this.reduceCacheSize(this.entryCache);
        this.reduceCacheSize(this.senseCache);
    }

    public int size() {
        return this.indexCache.size() + this.wordCache.size() + this.synsetCache.size() + this.entryCache.size() + this.senseCache.size();
    }

    public void cacheIndexWord(IIndexWord indexWord) {
        if (!this.isCachingEnabled()) {
            return;
        }
        this.indexCache.put((IIndexWordID)indexWord.getID(), indexWord);
        this.reduceCacheSize(this.indexCache);
    }

    public void cacheWord(IWord word) {
        if (!this.isCachingEnabled()) {
            return;
        }
        this.wordCache.put((IWordID)word.getID(), word);
        this.keyCache.put(word.getSenseKey(), word);
        this.reduceCacheSize(this.wordCache);
        this.reduceCacheSize(this.keyCache);
    }

    public void cacheSynset(ISynset synset) {
        if (!this.isCachingEnabled()) {
            return;
        }
        this.synsetCache.put((ISynsetID)synset.getID(), synset);
        this.reduceCacheSize(this.synsetCache);
    }

    public void cacheExceptionEntry(IExceptionEntry entry) {
        if (!this.isCachingEnabled()) {
            return;
        }
        this.entryCache.put((IExceptionEntryID)entry.getID(), entry);
        this.reduceCacheSize(this.entryCache);
    }

    public void cacheSenseEntry(ISenseEntry entry) {
        if (!this.isCachingEnabled()) {
            return;
        }
        this.senseCache.put(entry.getSenseKey(), entry);
        this.reduceCacheSize(this.senseCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reduceCacheSize(Map<?, ?> cache) {
        if (cache == null || cache.size() < this.fMaximumCapacity) {
            return;
        }
        Map<?, ?> map = cache;
        synchronized (map) {
            int remove = cache.size() - this.fMaximumCapacity;
            Iterator<?> itr = cache.keySet().iterator();
            for (int i = 0; i <= remove && itr.hasNext(); ++i) {
                itr.next();
                itr.remove();
            }
        }
    }

    public IIndexWord retrieveIndexWord(IIndexWordID id) {
        return this.indexCache.get(id);
    }

    public IWord retrieveWord(IWordID id) {
        return this.wordCache.get(id);
    }

    public IWord retrieveWord(ISenseKey key) {
        return this.keyCache.get(key);
    }

    public ISynset retrieveSynset(ISynsetID id) {
        return this.synsetCache.get(id);
    }

    public IExceptionEntry retrieveExceptionEntry(IExceptionEntryID id) {
        return this.entryCache.get(id);
    }

    public ISenseEntry retrieveSenseEntry(ISenseKey key) {
        return this.senseCache.get(key);
    }
}

