/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import edu.mit.jwi.item.Word;

public class WordID
implements IWordID {
    public static final String wordIDPrefix = "WID-";
    public static final String unknownLemma = "?";
    public static final String unknownWordNumber = "??";
    private final ISynsetID sID;
    private final int fNum;
    private final String fLemma;
    private static final char hyphen = '-';

    public WordID(int offset, POS pos, int number) {
        this((ISynsetID)new SynsetID(offset, pos), number);
    }

    public WordID(int offset, POS pos, String lemma) {
        this((ISynsetID)new SynsetID(offset, pos), lemma);
    }

    public WordID(ISynsetID id, int number) {
        if (id == null) {
            throw new NullPointerException();
        }
        Word.checkWordNumber(number);
        this.sID = id;
        this.fNum = number;
        this.fLemma = unknownLemma;
    }

    public WordID(ISynsetID synsetID, String lemma) {
        if (synsetID == null | lemma == null) {
            throw new NullPointerException();
        }
        this.sID = synsetID;
        this.fNum = -1;
        this.fLemma = lemma.toLowerCase();
    }

    public WordID(ISynsetID id, int number, String lemma) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (lemma.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        Word.checkWordNumber(number);
        this.sID = id;
        this.fNum = number;
        this.fLemma = lemma;
    }

    public ISynsetID getSynsetID() {
        return this.sID;
    }

    public int getSenseNumber() {
        return this.fNum;
    }

    public String getLemma() {
        return this.fLemma;
    }

    public POS getPOS() {
        return this.sID.getPOS();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.sID == null ? 0 : this.sID.hashCode());
        result = 31 * result + this.fNum;
        if (this.fLemma != null) {
            result = 31 * result + this.fLemma.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WordID other = (WordID)obj;
        if (this.sID == null ? other.sID != null : !this.sID.equals(other.sID)) {
            return false;
        }
        if (other.fNum != 0 & this.fNum != 0 & other.fNum != this.fNum) {
            return false;
        }
        return !(other.fLemma != null & this.fLemma != null) || other.fLemma.equals(this.fLemma);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16 + this.fLemma.length());
        sb.append(wordIDPrefix);
        sb.append(Synset.zeroFillOffset(this.sID.getOffset()));
        sb.append('-');
        sb.append(Character.toUpperCase(this.sID.getPOS().getTag()));
        sb.append('-');
        sb.append(this.fNum < 0 ? unknownWordNumber : Word.zeroFillWordNumber(this.fNum));
        sb.append('-');
        sb.append(this.fLemma);
        return sb.toString();
    }

    public static IWordID parseWordID(String value) {
        if (value == null || value.length() < 19) {
            return null;
        }
        if (!value.startsWith(wordIDPrefix)) {
            return null;
        }
        int offset = -1;
        try {
            offset = Integer.parseInt(value.substring(4, 12));
        }
        catch (Exception e) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        POS pos = null;
        try {
            pos = POS.getPartOfSpeech(value.charAt(13));
        }
        catch (Exception e) {
            return null;
        }
        if (pos == null) {
            return null;
        }
        SynsetID id = new SynsetID(offset, pos);
        int num = -1;
        try {
            num = Integer.parseInt(value.substring(15, 17), 16);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (num > 0) {
            return new WordID((ISynsetID)id, num);
        }
        String lemma = value.substring(18);
        if (lemma.equals(unknownLemma) | lemma.length() == 0) {
            return null;
        }
        return new WordID((ISynsetID)id, lemma);
    }
}

