/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.content;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refexp.models.IRefExpModel;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel;
import edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionComparator;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public class RefExpContentProvider
extends StoryEditorContentProvider {
    public RefExpContentProvider(IStoryEditor input) {
        super(RefExpRep.getInstance(), input, "(no referring expressions)");
    }

    public boolean hasChildren(Object element) {
        IRefExp refexp;
        IRefExpModel model;
        Object data = element;
        if (data instanceof IDesc) {
            IDesc desc = (IDesc)data;
            if (RefExpRep.getInstance().isType((IHasRep)desc)) {
                data = (IRefExp)desc.getData();
            }
        }
        if (data instanceof IRefExpModel) {
            model = (IRefExpModel)data;
            return !model.getProperties().isEmpty();
        }
        if (data instanceof IRefExpPropModel) {
            model = (IRefExpPropModel)data;
            return !model.getProperties().isEmpty();
        }
        if (data instanceof IRefExp && RefPropRep.hasProperties((IRefExp)(refexp = (IRefExp)data), (IStoryModel)this.getStoryEditor().getStoryModel())) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parent) {
        IRefExpModel model;
        Object[] defaultChildren = super.getChildren(parent);
        Object data = parent;
        if (data instanceof IDesc) {
            IDesc desc = (IDesc)data;
            if (RefExpRep.getInstance().isType((IHasRep)desc)) {
                data = desc.getData();
            }
            if (CorefRep.getInstance().isType((IHasRep)desc)) {
                data = desc.getData();
            }
        }
        if (data instanceof IRefExpModel) {
            model = (IRefExpModel)data;
            ArrayList<StoryEditorContentProvider.Element> result = new ArrayList<StoryEditorContentProvider.Element>(model.getProperties().size());
            for (IReferentPropertyModel propModel : model.getProperties()) {
                result.add(RefExpContentProvider.makeChild((Object)model, (Object)propModel));
            }
            return result.toArray();
        }
        if (data instanceof IRefExpPropModel) {
            model = (IRefExpPropModel)data;
            ArrayList<StoryEditorContentProvider.Element> result = new ArrayList<StoryEditorContentProvider.Element>(model.getProperties().size());
            for (IReferentPropertyModel propModel : model.getProperties()) {
                result.add(RefExpContentProvider.makeChild((Object)model, (Object)propModel));
            }
            return result.toArray();
        }
        if (data instanceof IRefExp) {
            IRefExp refexp = (IRefExp)data;
            ArrayList<Object> result = new ArrayList<Object>();
            IDescSet props = RefPropRep.collectProperties((IRefExp)refexp, (IStoryModel)this.getStoryEditor().getStoryModel());
            if (props.size() < 2) {
                result.addAll((Collection<Object>)props);
            } else {
                TreeMap<ISegmentSet, IDesc> propMap = new TreeMap<ISegmentSet, IDesc>(HasPositionComparator.getInstance());
                for (IDesc propDesc : props) {
                    IReferentProperty prop = (IReferentProperty)propDesc.getData();
                    propMap.put(prop.getExtent(), propDesc);
                }
                result.addAll(propMap.values());
            }
            if (defaultChildren != null) {
                Object[] objectArray = defaultChildren;
                int n = defaultChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    result.add(child);
                    ++n2;
                }
            }
            return result.toArray();
        }
        return defaultChildren;
    }
}

