/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.controllers;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel;
import edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel;
import edu.mit.discourse.core.rep.refprops.model.ReferentPropertyModel;
import edu.mit.discourse.ui.controllers.CorefController;
import edu.mit.discourse.ui.controllers.IRefExpPropController;
import edu.mit.discourse.ui.controllers.IReferentPropertyController;
import edu.mit.discourse.ui.controllers.ReferentPropertyController;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefExpPropController
extends DescController<IRefExpPropModel>
implements IRefExpPropController {
    private final IReferentPropertyController propertyController;

    public RefExpPropController(IRefExpPropModel model, IStoryEditor editor, String refAnnoID) {
        this(model, editor, refAnnoID, null);
    }

    public RefExpPropController(IRefExpPropModel model, IStoryEditor editor, String refAnnoID, String propAnnoID) {
        super((IDescModel)model, refAnnoID, editor, (ICaptureStrategy)new CorefController.RefExpSelectionDialogCaptureStrategy(editor, (IDescModel)model));
        this.propertyController = propAnnoID == null ? null : new ReferentPropertyController(editor, propAnnoID);
    }

    @Override
    public IRefExpPropModel getDescModel() {
        return (IRefExpPropModel)super.getDescModel();
    }

    @Override
    public IRefExpPropModel getModel() {
        return this.getDescModel();
    }

    @Override
    public void commit() {
        IModelChange change;
        IRefExpPropModel model = this.getDescModel();
        if (model.getMessageType() == 3) {
            return;
        }
        LinkedList<Object> changes = new LinkedList<Object>();
        Timing editTime = new Timing(model.getStart(), "user");
        IDesc refDesc = model.getDesc();
        for (IReferentPropertyModel propModel : model.getProperties()) {
            propModel.setReferringExpression(refDesc);
            IReferentProperty refProp = propModel.create();
            IHasPosition p = refProp.calculatePosition();
            change = ChangeUtils.createModelEdit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)RefPropRep.getInstance(), (IHasPosition)p, (IData)refProp, (ITiming)editTime, (IDesc)propModel.getLoaded());
            changes.add(change);
        }
        IRefExp oldRefexp = (IRefExp)refDesc.getData();
        IDescSet currProps = RefPropRep.collectProperties((IRefExp)oldRefexp, (IStoryModel)this.getStoryEditor().getStoryModel());
        for (IReferentPropertyModel propModel : model.getProperties()) {
            currProps.remove((Object)propModel.getLoaded());
        }
        changes.add(new RemoveDescriptionsChange((Collection)currProps));
        change = new CompositeModelChange(changes);
        this.getStoryEditor().getStoryModel().applyChange((Object)this, change, false);
        this.clear();
    }

    @Override
    public void edit(IDesc desc) {
        if (desc != null && !RefPropRep.getInstance().isType((IHasRep)desc)) {
            throw new IllegalArgumentException();
        }
        IReferentProperty refProp = (IReferentProperty)desc.getData();
        this.getDescModel().setDesc(refProp.getReferringExpression());
        this.getPropertyController().edit(desc);
    }

    @Override
    public IReferentPropertyController getPropertyController() {
        return this.propertyController;
    }

    @Override
    public void createProperty() {
        IReferentPropertyModel propertyModel = this.propertyController.getModel();
        IDesc editTarget = propertyModel.getLoaded();
        ReferentPropertyModel property = null;
        if (editTarget == null) {
            property = new ReferentPropertyModel(this.getModel().getStoryModel());
            this.getModel().getProperties().add((Object)property);
        } else {
            for (IReferentPropertyModel model : this.getModel().getProperties()) {
                if (model.getLoaded() != editTarget) continue;
                property = model;
                break;
            }
        }
        if (property == null) {
            throw new IllegalStateException();
        }
        property.setType(propertyModel.getType());
        property.setSegments((Collection)propertyModel.getSegments());
        this.propertyController.clear();
    }
}

