/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.controllers;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.model.IReferenceModel;
import edu.mit.discourse.core.rep.referent.model.IReferentModel;
import edu.mit.discourse.core.rep.referent.model.ReferenceModel;
import edu.mit.discourse.core.rep.referent.model.ReferentModel;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.ui.controllers.IReferenceController;
import edu.mit.discourse.ui.controllers.IReferentController;
import edu.mit.discourse.ui.controllers.ReferenceController;
import edu.mit.discourse.ui.dialogs.ReferenceFinderDialog;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.actions.IUpdatingAction;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.EditAction;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.ActionGroup;

public class ReferentController
implements IReferentController {
    private final IStoryEditor editor;
    private final IReferentModel model;
    private final IReferenceController refController;
    private StoryEditorUndoRedoActionGroup undoRedoActions;
    private EditElementAction editAction;
    private DeleteElementAction deleteAction;

    public ReferentController(IStoryEditor editor, String refAnnoID, String propAnnoID) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = new ReferentModel((IStoryModel)editor.getStoryModel());
        this.refController = new ReferenceController(editor, refAnnoID);
    }

    public void dispose() {
        this.refController.dispose();
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public IReferentModel getReferentModel() {
        return this.model;
    }

    public IReferenceController getReferenceController() {
        return this.refController;
    }

    public void setName(String name) {
        int i = 0;
        if (name.length() > 0) {
            while (Character.isWhitespace(name.charAt(i))) {
                ++i;
            }
        }
        this.model.setName(name.substring(i));
    }

    public void addReference() {
        IReferenceModel refModel = this.refController.getModel();
        IHasPositionSet segs = refModel.getSegments();
        if (segs.isEmpty()) {
            return;
        }
        IReference loaded = refModel.getLoaded();
        if (loaded == null) {
            ReferenceModel ref = new ReferenceModel((IStoryModel)this.editor.getStoryModel());
            ref.setSegments((Collection)segs);
            this.model.addReference((IReferenceModel)ref);
        } else if (loaded instanceof IReferenceModel) {
            IReferenceModel ref = (IReferenceModel)loaded;
            ref.setSegments((Collection)segs);
        } else {
            IReferenceModel ref = this.model.getReference(loaded.getID());
            if (ref != null) {
                ref.setSegments((Collection)segs);
            }
        }
        refModel.clear();
    }

    public void addReferencesByPattern() {
        List<IHasPosition> ps = ReferenceFinderDialog.open(this.editor, (IReferent)this.model);
        if (ps == null || ps.isEmpty()) {
            return;
        }
        IUndoableStoryModel storyModel = this.editor.getStoryModel();
        for (IHasPosition p : ps) {
            ReferenceModel newRef = new ReferenceModel((IStoryModel)storyModel);
            newRef.setSegments(Collections.singleton(new Segment(p, TokenRep.getInstance(), storyModel.getData())));
            this.model.addReference((IReferenceModel)newRef);
        }
    }

    public void removeReference(int id) {
        this.model.removeReference(id);
    }

    public void clear() {
        this.model.clear();
        this.refController.clear();
    }

    public void commit() {
        AddDescriptionsChange change;
        if (this.model.getMessageType() > 1) {
            return;
        }
        IDesc loaded = this.model.getLoaded();
        long id = loaded == null ? this.editor.getStoryModel().getNextID() : loaded.getID();
        IReferent data = this.model.toReferent();
        IHasPosition pos = data.calculatePosition();
        IMetaDataMap metadata = loaded == null ? null : loaded.getMetaData();
        Desc refDesc = new Desc(id, ReferentRep.getInstance(), pos, (IData)data, (Iterable)metadata);
        refDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)refDesc, (IMetaData)Origin.USER_SPECIFIED));
        Timing timing = new Timing(this.model.getStart(), "user");
        refDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)refDesc, (IMetaData)timing));
        if (!this.editor.getStoryModel().supports(RefPropRep.getInstance())) {
            change = new AddDescriptionsChange((IDesc)refDesc);
            if (loaded != null) {
                change = new CompositeModelChange(new IModelChange[]{new RemoveDescriptionsChange(loaded), change});
            }
        } else {
            LinkedList<Desc> toAdd = new LinkedList<Desc>();
            LinkedList<IDesc> toRemove = new LinkedList<IDesc>();
            toAdd.add(refDesc);
            if (loaded != null) {
                toRemove.add(loaded);
            }
            change = new AddDescriptionsChange(toAdd);
            if (!toRemove.isEmpty()) {
                change = new CompositeModelChange(new IModelChange[]{new RemoveDescriptionsChange(toRemove), change});
            }
        }
        this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        this.clear();
    }

    public void load(IDesc desc) {
        this.clear();
        this.model.load(desc);
    }

    public EditElementAction getActionEdit() {
        if (this.editAction == null) {
            this.editAction = new EditElementAction();
        }
        return this.editAction;
    }

    public DeleteElementAction getActionDelete() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteElementAction();
        }
        return this.deleteAction;
    }

    public ActionGroup getUndoRedoActionGroup() {
        if (this.undoRedoActions == null) {
            this.undoRedoActions = new StoryEditorUndoRedoActionGroup(this.editor);
        }
        return this.undoRedoActions;
    }

    protected class DeleteElementAction
    extends DeleteAction
    implements IUpdatingAction {
        IReference ref;

        protected DeleteElementAction() {
        }

        protected void doDelete() {
            ReferentController.this.removeReference(this.ref.getID());
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.ref = (IReference)SelectionUtils.extractSingle((ISelection)event.getSelection(), IReference.class);
            this.setEnabled(this.ref != null);
        }
    }

    protected class EditElementAction
    extends EditAction
    implements IUpdatingAction {
        private IReference ref;

        protected EditElementAction() {
        }

        protected void doEdit() {
            if (this.ref != null) {
                ReferentController.this.getReferenceController().load(this.ref);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.ref = (IReference)SelectionUtils.extractSingle((ISelection)event.getSelection(), IReference.class);
            this.setEnabled(this.ref != null);
        }
    }
}

