/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.helpers;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel;
import edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel;
import edu.mit.discourse.core.rep.refprops.model.RefExpPropModel;
import edu.mit.discourse.ui.content.RefExpContentProvider;
import edu.mit.discourse.ui.controllers.IRefExpPropController;
import edu.mit.discourse.ui.controllers.IReferentPropertyController;
import edu.mit.discourse.ui.controllers.RefExpPropController;
import edu.mit.discourse.ui.label.RefExpDisplayText;
import edu.mit.discourse.ui.label.RefExpLabelProvider;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.story.core.datamodel.IViewModel;
import edu.mit.story.core.datamodel.ModelWrapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.services.IServiceLocator;

public class RefPropCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = RefPropCreatorPage.class.getName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Referent Properties";
    public static String actionLabelSave = "Save Referent Properties";
    public static String actionLabelClear = "Clear Referent Properties";
    public static String actionLabelCancel = "Cancel Edit";
    public static IMessageProvider clearedMessage = new Message("Use this page to create new referent properties", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add these properties to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change these properties in the story model", 1);
    protected IRefExpPropController controller;
    protected IModelListener modelListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (RefPropCreatorPage.this.getControl().isDisposed()) {
                return;
            }
            if (e.affects(RefExpRep.getInstance()) || e.affects(RefPropRep.getInstance())) {
                RefPropCreatorPage.this.updateFromModel();
            }
        }
    };
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected DescCaptureWidget<IDescController<IRefExpPropModel>> refExpWidget;
    protected SegmentSetCaptureWidget<IReferentPropertyController> refPropWidget;
    protected TreeViewer refViewer;
    protected ComboViewer typeCombo;
    protected Button createPropertyButton;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction createPropertyAction;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)RefPropCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.setControl((Control)control);
        this.controller = new RefExpPropController((IRefExpPropModel)new RefExpPropModel((IStoryModel)this.getStoryEditor().getStoryModel()), this.getStoryEditor(), "edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2");
        this.getStoryEditor().getStoryModel().addModelListener(this.modelListener);
        this.messageManager = new MessageProviderManager();
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getDescModel());
        this.messageManager.add((INotifyingMessageProvider)this.controller.getPropertyController().getModel(), true);
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RefPropCreatorPage.this.updateFromModel();
            }
        });
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)this.messageBar);
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        SashForm sash = new SashForm(control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite widgets = new Composite((Composite)sash, 0);
        widgets.setLayoutData((Object)new GridData(4, 128, true, false));
        widgets.setBackground(control.getBackground());
        widgets.setForeground(control.getForeground());
        widgets.setLayout((Layout)new GridLayout(2, false));
        this.createControlRefExp(widgets);
        this.createControlRefProp(widgets);
        this.createControlCommit(widgets);
        this.refViewer = new TreeViewer((Composite)sash, 2048);
        this.refViewer.setContentProvider((IContentProvider)new RefExpContentProvider(this.getStoryEditor()));
        this.refViewer.setLabelProvider((IBaseLabelProvider)new RefExpLabelProvider(this.getStoryEditor()));
        this.refViewer.setInput((Object)new ModelWrapper(new IViewModel[]{this.controller.getModel()}));
        sash.setWeights(new int[]{3, 1});
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        manager.appendToGroup("group.edit", (IContributionItem)CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow()));
        Tree tree = this.refViewer.getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.updateFromModel();
    }

    protected void createControlRefExp(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Referring Expression");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refExpWidget = new DescCaptureWidget(parent, 0, (IDescController)this.controller, (IDescDisplayText)RefExpDisplayText.getInstance());
        this.refExpWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refExpWidget.getCaptureAction().setText("Capture Referring Expression");
        this.refExpWidget.getCaptureAction().setToolTipText("Capture Referring Expression");
        this.refExpWidget.getClearAction().setText("Clear Referring Expression");
        this.refExpWidget.getClearAction().setToolTipText("Clear Referring Expression");
    }

    protected void createControlRefProp(Composite parent) {
        Label rule = new Label(parent, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Property");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.refPropWidget = new SegmentSetCaptureWidget<IReferentPropertyController>(parent, 0, this.controller.getPropertyController()){

            protected void createLeadingControls(Composite parent) {
                parent.setLayout((Layout)RefPropCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                RefPropCreatorPage.this.typeCombo = new ComboViewer(parent, 8);
                RefPropCreatorPage.this.typeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
                RefPropCreatorPage.this.typeCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
                PropertyType[] values = PropertyType.values();
                RefPropCreatorPage.this.typeCombo.setInput((Object)values);
                RefPropCreatorPage.this.typeCombo.getCombo().setVisibleItemCount(values.length);
                RefPropCreatorPage.this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        PropertyType type = (PropertyType)SelectionUtils.extractSingle((ISelection)event.getSelection(), PropertyType.class);
                        (this).RefPropCreatorPage.this.controller.getPropertyController().setType(type);
                    }
                });
            }

            protected void createTrailingControls(Composite parent) {
                parent.setLayout((Layout)RefPropCreatorPage.zeroMargins((GridLayout)new GridLayout()));
                RefPropCreatorPage.this.createPropertyButton = new Button(parent, 0);
                RefPropCreatorPage.this.createPropertyButton.setText("Create");
                RefPropCreatorPage.this.createPropertyAction = new ButtonAction(RefPropCreatorPage.this.createPropertyButton){

                    public void run() {
                        (this).RefPropCreatorPage.this.controller.createProperty();
                    }
                };
            }
        };
        this.refPropWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refPropWidget.getAddAction().setText("Add to Property");
        this.refPropWidget.getAddAction().setToolTipText("Add to Property");
        this.refPropWidget.getSubtractAction().setText("Subtract from Property");
        this.refPropWidget.getSubtractAction().setToolTipText("Subtract from Property");
        this.refPropWidget.getClearAction().setText("Clear Property");
        this.refPropWidget.getClearAction().setToolTipText("Clear Property");
    }

    protected void createControlCommit(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite buttons = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttons);
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttons.setLayout((Layout)RefPropCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        label = new Label(buttons, 0);
        label.setBackground(buttons.getBackground());
        label.setForeground(buttons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                RefPropCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                RefPropCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.refExpWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.refPropWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        actionBars.setGlobalActionHandler(this.refExpWidget.getCaptureAction().getActionDefinitionId(), this.refExpWidget.getCaptureAction());
        actionBars.setGlobalActionHandler(this.refPropWidget.getAddAction().getActionDefinitionId(), this.refPropWidget.getAddAction());
        this.refPropWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.2");
        actionBars.setGlobalActionHandler(this.refPropWidget.getSubtractAction().getActionDefinitionId(), this.refPropWidget.getSubtractAction());
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        this.createPropertyAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.2");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        actionBars.setGlobalActionHandler(this.createPropertyAction.getActionDefinitionId(), (IAction)this.createPropertyAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        this.refPropWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.2");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        actionBars.setGlobalActionHandler(this.refPropWidget.getClearAction().getActionDefinitionId(), this.refPropWidget.getClearAction());
    }

    protected void updateFromModel() {
        String clearActionLabel;
        IMessageProvider defaultMsg;
        IRefExpPropModel refModel = this.controller.getModel();
        IReferentPropertyModel propModel = this.controller.getPropertyController().getModel();
        boolean isMainLoaded = refModel.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isMainLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableCommit = !refModel.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !refModel.isCleared() || !refModel.isCleared();
        boolean enableProps = refModel.getStoryModel().supports(RefPropRep.getInstance());
        boolean enableCreate = enableProps && !propModel.isCleared() && propModel.getMessageType() != 3;
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String string = clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        if (enableCreate != this.createPropertyButton.isEnabled()) {
            this.createPropertyButton.setEnabled(enableCreate);
        }
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (enableProps != this.refPropWidget.isEnabled()) {
            this.refPropWidget.setEnabled(enableProps);
        }
        if (enableProps != this.typeCombo.getControl().isEnabled()) {
            this.typeCombo.getControl().setEnabled(enableProps);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (propModel.getLoaded() != null) {
            boolean foundIt = false;
            for (IReferentPropertyModel pModel : refModel.getProperties()) {
                if (pModel.getLoaded() != propModel.getLoaded()) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) {
                propModel.clear();
            }
        }
        StructuredSelection typeSel = StructuredSelection.EMPTY;
        if (propModel.getType() != null) {
            typeSel = new StructuredSelection((Object)propModel.getType());
        }
        if (!this.typeCombo.getSelection().equals(typeSel)) {
            this.typeCombo.setSelection((ISelection)typeSel);
        }
        this.refViewer.getTree().setRedraw(false);
        this.refViewer.refresh();
        this.refViewer.expandAll();
        this.refViewer.getTree().setRedraw(true);
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public IRefExpPropController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        this.getStoryEditor().getStoryModel().removeModelListener(this.modelListener);
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.refViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.refViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

