/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.label;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class RefExpLabelProvider
extends StoryModelLabelProvider {
    protected Image refImg;
    protected Image propImg;

    public RefExpLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        long id = -1L;
        Object data = element;
        if (data instanceof IDesc) {
            IDesc d = (IDesc)data;
            id = d.getID();
            data = d.getData();
        }
        if (data instanceof IRefExp) {
            IRefExp refexp = (IRefExp)data;
            StyledString result = new StyledString();
            result.append(refexp.getDisplayText());
            RefExpLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                RefExpLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        if (data instanceof IReferentProperty) {
            IReferentProperty prop = (IReferentProperty)data;
            StyledString result = new StyledString();
            StyledString.Styler styler = prop.getType() == PropertyType.UNKNOWN ? TAG_STYLER : StyledString.COUNTER_STYLER;
            result.append(prop.getType().getName(), styler);
            result.append(' ');
            result.append(prop.getDisplayText());
            RefExpLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                RefExpLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            IDesc desc = (IDesc)element;
            element = desc.getData();
        }
        if (element instanceof IRefExp) {
            return this.getRefExpImage();
        }
        if (element instanceof IReferentProperty) {
            return this.getPropertyImage();
        }
        return super.getImage(element);
    }

    protected Image getRefExpImage() {
        if (this.refImg == null) {
            this.refImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/reference.gif");
        }
        return this.refImg;
    }

    protected Image getPropertyImage() {
        if (this.propImg == null) {
            this.propImg = DiscourseUIPlugin.getDefault().getImageRegistry().get("obj16/refprop.gif");
        }
        return this.propImg;
    }
}

