/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relprops;

import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.relprops.IRelPropDescriptor;
import edu.mit.discourse.ui.relprops.IRelPropManager;
import edu.mit.discourse.ui.relprops.IRelPropValue;
import edu.mit.discourse.ui.relprops.RelPropDescriptor;
import edu.mit.discourse.ui.relprops.RelPropValue;
import edu.mit.story.core.manager.AbstractManager;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.Property;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.util.XMLUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelPropManager
extends AbstractManager<IRelPropDescriptor>
implements IRelPropManager {
    private static Schema schema;
    private static Pattern wsPattern;
    private List<IRelPropDescriptor> autoProps;
    private List<IRelPropDescriptor> dropProps;

    static {
        wsPattern = Pattern.compile("\\s+");
    }

    protected Map<String, IRelPropDescriptor> createIDMap() {
        return new LinkedHashMap<String, IRelPropDescriptor>();
    }

    protected boolean doInit() {
        Document doc;
        String xml = DiscourseUIPlugin.getDefault().getPreferenceStore().getString("RelPropXML");
        Document document = doc = xml == null ? null : XMLUtils.fromString((String)xml);
        if (doc == null) {
            URL url = this.getClass().getResource("default.xml");
            if (url == null) {
                LogUtils.logError((Plugin)DiscourseUIPlugin.getDefault(), (Throwable)new NullPointerException());
                return false;
            }
            StringBuilder sb = new StringBuilder();
            try {
                StringUtils.loadStreamIntoBuffer((Appendable)sb, (InputStream)new BufferedInputStream(url.openStream()));
            }
            catch (IOException e) {
                LogUtils.logError((Plugin)DiscourseUIPlugin.getDefault(), (Throwable)e);
                return false;
            }
            doc = XMLUtils.fromString((String)sb.toString());
        }
        if (doc == null) {
            return false;
        }
        return this.load(doc, false);
    }

    @Override
    public List<IRelPropDescriptor> getAutomaticProperties() {
        return this.autoProps;
    }

    @Override
    public List<IRelPropDescriptor> getDropdownProperties() {
        return this.dropProps;
    }

    @Override
    public boolean load(Document xml) {
        return this.load(xml, true);
    }

    protected boolean load(Document xml, boolean saveToPrefs) {
        List<IRelPropDescriptor> props = RelPropManager.extractRelProps(xml);
        if (props == null || props.isEmpty()) {
            return false;
        }
        ArrayList<IRelPropDescriptor> autoList = new ArrayList<IRelPropDescriptor>();
        ArrayList<IRelPropDescriptor> dropList = new ArrayList<IRelPropDescriptor>();
        Map<String, IRelPropDescriptor> newMap = this.createIDMap();
        for (IRelPropDescriptor desc : props) {
            IRelPropDescriptor old = newMap.put(desc.getID(), desc);
            if (old != null) {
                LogUtils.logWarning((Plugin)DiscourseUIPlugin.getDefault(), (String)("Duplicate property id: " + desc.getID()));
            }
            if (desc.isAutomatic()) {
                autoList.add(desc);
            }
            if (!desc.isDropdown()) continue;
            dropList.add(desc);
        }
        if (newMap.isEmpty()) {
            return false;
        }
        autoList.trimToSize();
        this.autoProps = Collections.unmodifiableList(autoList);
        this.dropProps = Collections.unmodifiableList(dropList);
        this.idMap = newMap;
        this.descriptorList = null;
        if (saveToPrefs) {
            ArrayList<IRelPropDescriptor> propList = new ArrayList<IRelPropDescriptor>(this.idMap.values());
            Document doc = RelPropManager.exportRelProps(propList);
            String xmlStr = XMLUtils.toString((Document)doc);
            xmlStr = wsPattern.matcher(xmlStr).replaceAll("");
            DiscourseUIPlugin.getDefault().getPreferenceStore().setValue("RelPropXML", xmlStr);
        }
        return true;
    }

    @Override
    public Document export() {
        return RelPropManager.exportRelProps(this.getDescriptors());
    }

    @Override
    public IRelPropDescriptor getDescriptor(IProperty p, List<IProperty> ps) {
        LinkedList<IRelPropDescriptor> queue = new LinkedList<IRelPropDescriptor>(this.getAutomaticProperties());
        block0: while (!queue.isEmpty()) {
            IRelPropDescriptor desc = (IRelPropDescriptor)queue.remove(0);
            if (((String)p.getKey()).equals(desc.getName())) {
                return desc;
            }
            IProperty foundP = Property.getProperty((String)desc.getName(), ps);
            if (foundP == null) continue;
            for (IRelPropValue v : desc.getValues()) {
                if (!v.getName().equals(foundP.getValue())) continue;
                for (String propID : v.getResultIDs()) {
                    desc = (IRelPropDescriptor)this.getDescriptor(propID);
                    if (desc == null) continue;
                    queue.add(desc);
                }
                continue block0;
            }
        }
        for (IRelPropDescriptor d : this.getDescriptors()) {
            if (!((String)p.getKey()).equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    @Override
    public List<String> getOptions(IProperty p, List<IProperty> ps) {
        IRelPropDescriptor desc = this.getDescriptor(p, ps);
        if (desc == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(desc.getValues().size());
        for (IRelPropValue v : desc.getValues()) {
            result.add(v.getName());
        }
        return result;
    }

    @Override
    public List<String> getResults(IProperty p, List<IProperty> ps) {
        IRelPropDescriptor desc = this.getDescriptor(p, ps);
        if (desc == null) {
            return null;
        }
        for (IRelPropValue v : desc.getValues()) {
            if (!v.getName().equals(p.getValue())) continue;
            ArrayList<String> results = new ArrayList<String>(v.getResultIDs().size());
            for (String propID : v.getResultIDs()) {
                desc = (IRelPropDescriptor)this.getDescriptor(propID);
                if (desc == null) continue;
                results.add(desc.getName());
            }
            return results;
        }
        return null;
    }

    @Override
    public List<String> getDropdownProperties(IRelation rel) {
        List<IRelPropDescriptor> descs = this.getDropdownProperties();
        if (descs.isEmpty()) {
            return new ArrayList<String>(1);
        }
        TreeSet<String> holder = new TreeSet<String>();
        for (IRelPropDescriptor desc : descs) {
            List<String> options = this.getPrefixedProperties(desc, rel);
            holder.addAll(options);
        }
        for (IProperty p : rel.getProperties()) {
            holder.remove(p.getKey());
        }
        return new ArrayList<String>(holder);
    }

    protected List<String> getPrefixedProperties(IRelPropDescriptor desc, IRelation rel) {
        List<String> pStrs = desc.getPrefixes();
        if (pStrs.isEmpty()) {
            return Collections.singletonList(desc.getName());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String pStr : desc.getPrefixes()) {
            IRelPropDescriptor.Prefix prefix = IRelPropDescriptor.Prefix.valueOf(pStr);
            result.addAll(prefix.prefixProperty(desc.getName(), rel));
        }
        return result;
    }

    public static Schema getSchema() {
        if (schema == null) {
            URL dtd = RelPropManager.class.getResource("relprops.xsd");
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                schema = factory.newSchema(new StreamSource(dtd.openStream()));
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.logError((Plugin)DiscourseUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return schema;
    }

    public static List<IRelPropDescriptor> extractRelProps(Document xml) {
        Validator v = RelPropManager.getSchema().newValidator();
        try {
            v.validate(new DOMSource(xml));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NodeList head = xml.getElementsByTagName("properties");
        if (head.getLength() != 1) {
            LogUtils.logError((Plugin)DiscourseUIPlugin.getDefault(), (String)"Misformatted Properties XML: Missing or multiple properties node");
            return null;
        }
        ArrayList<IRelPropDescriptor> result = new ArrayList<IRelPropDescriptor>();
        Element headElem = (Element)head.item(0);
        NodeList nodes = headElem.getElementsByTagName("property");
        int i = 0;
        while (i < nodes.getLength()) {
            IRelPropDescriptor desc = RelPropManager.extractProperty((Element)nodes.item(i));
            if (desc != null) {
                result.add(desc);
            }
            ++i;
        }
        HashMap<String, IRelPropDescriptor> descMap = new HashMap<String, IRelPropDescriptor>(result.size());
        for (IRelPropDescriptor d : result) {
            descMap.put(d.getID(), d);
        }
        nodes = headElem.getElementsByTagName("mirrorProperty");
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            result.addAll(RelPropManager.extractMirrorProperties((Element)nodes.item(i2), descMap));
            ++i2;
        }
        return result;
    }

    protected static IRelPropDescriptor extractProperty(Element elem) {
        String id = elem.getAttribute("id");
        String name = elem.getAttribute("name");
        String desc = RelPropManager.getDescription(elem);
        boolean isAuto = Boolean.parseBoolean(elem.getAttribute("auto"));
        boolean isDropdown = Boolean.parseBoolean(elem.getAttribute("dropdown"));
        List<String> prefixList = BlockMapper.SPACE.reconstitute(elem.getAttribute("prefixes"));
        if (prefixList != null) {
            LinkedHashSet<String> prefixSet = new LinkedHashSet<String>(prefixList.size());
            prefixSet.addAll(prefixList);
            prefixList = Arrays.asList(prefixSet.toArray(new String[prefixSet.size()]));
        }
        ArrayList<IRelPropValue> values = new ArrayList<IRelPropValue>();
        for (Element child : RelPropManager.getValueNodes(elem)) {
            IRelPropValue value = RelPropManager.extractValue(id, child);
            if (value == null) continue;
            values.add(value);
        }
        return new RelPropDescriptor(id, name, desc, values, isAuto, isDropdown, prefixList);
    }

    protected static List<IRelPropDescriptor> extractMirrorProperties(Element elem, Map<String, IRelPropDescriptor> map) {
        String mirrorID = elem.getAttribute("mirrors");
        String postfix = elem.getAttribute("postfix");
        String desc = RelPropManager.getDescription(elem);
        boolean isAuto = Boolean.parseBoolean(elem.getAttribute("auto"));
        boolean isDropdown = Boolean.parseBoolean(elem.getAttribute("dropdown"));
        LinkedHashSet<IRelPropDescriptor> mirrorSet = new LinkedHashSet<IRelPropDescriptor>();
        IRelPropDescriptor d = map.get(mirrorID);
        LinkedList<IRelPropDescriptor> queue = new LinkedList<IRelPropDescriptor>();
        queue.add(d);
        while (!queue.isEmpty()) {
            d = (IRelPropDescriptor)queue.remove(0);
            if (!mirrorSet.add(d)) continue;
            for (IRelPropValue v : d.getValues()) {
                for (String result : v.getResultIDs()) {
                    d = map.get(result);
                    if (d == null) continue;
                    queue.add(d);
                }
            }
        }
        ArrayList<IRelPropDescriptor> result = new ArrayList<IRelPropDescriptor>();
        Iterator i = mirrorSet.iterator();
        d = (IRelPropDescriptor)i.next();
        RelPropDescriptor copy = new RelPropDescriptor(String.valueOf(d.getID()) + postfix, d.getID(), String.valueOf(d.getName()) + postfix, desc, RelPropManager.copyValues(d.getValues(), postfix), isAuto, isDropdown, d.getPrefixes());
        RelPropManager.checkProperty(copy, map);
        result.add(copy);
        while (i.hasNext()) {
            d = (IRelPropDescriptor)i.next();
            copy = new RelPropDescriptor(String.valueOf(d.getID()) + postfix, d.getID(), String.valueOf(d.getName()) + postfix, d.getDescription(), RelPropManager.copyValues(d.getValues(), postfix), d.isAutomatic(), d.isDropdown(), d.getPrefixes());
            RelPropManager.checkProperty(copy, map);
            result.add(copy);
        }
        return result;
    }

    protected static void checkProperty(IRelPropDescriptor d, Map<String, IRelPropDescriptor> map) {
        IRelPropDescriptor exists = map.get(d.getID());
        if (exists != null && !exists.isMirror()) {
            throw new IllegalArgumentException("Mirrored property id overlaps with existing id: " + d.getID());
        }
    }

    protected static List<IRelPropValue> copyValues(List<IRelPropValue> values, String postfix) {
        ArrayList<IRelPropValue> result = new ArrayList<IRelPropValue>(values.size());
        for (IRelPropValue value : values) {
            ArrayList<String> ids = new ArrayList<String>(value.getResultIDs().size());
            for (String id : value.getResultIDs()) {
                ids.add(String.valueOf(id) + postfix);
            }
            result.add(new RelPropValue(value.getName(), value.getDescription(), ids));
        }
        return result;
    }

    protected static String getDescription(Element e) {
        NodeList children = e.getElementsByTagName("description");
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            if (child.getParentNode() == e) {
                return child.getTextContent();
            }
            ++i;
        }
        return "";
    }

    protected static IRelPropValue extractValue(String id, Element e) {
        String name = e.getAttribute("name");
        String desc = RelPropManager.getDescription(e);
        String resultStr = e.getAttribute("result");
        List resultList = BlockMapper.SPACE.reconstitute(resultStr);
        return new RelPropValue(name, desc, resultList);
    }

    protected static List<Element> getValueNodes(Element e) {
        NodeList children = e.getElementsByTagName("value");
        ArrayList<Element> result = new ArrayList<Element>();
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            if (child.getParentNode() == e) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    public static Document exportRelProps(List<IRelPropDescriptor> props) {
        Document result = XMLUtils.createEmptyDocument((String)"properties");
        Element headNode = (Element)result.getElementsByTagName("properties").item(0);
        for (IRelPropDescriptor desc : props) {
            RelPropManager.appendDescriptor(desc, headNode, result);
        }
        return result;
    }

    protected static void appendDescriptor(IRelPropDescriptor desc, Element parent, Document doc) {
        Element elem = doc.createElement("property");
        elem.setAttribute("id", desc.getID());
        elem.setAttribute("name", desc.getName());
        if (desc.isAutomatic()) {
            elem.setAttribute("auto", "true");
        }
        if (desc.isDropdown()) {
            elem.setAttribute("dropdown", "true");
            String string = BlockMapper.SPACE.serialize(desc.getPrefixes());
            if (string.trim().length() != 0) {
                elem.setAttribute("prefixes", string);
            }
        }
        RelPropManager.appendDescription(desc.getDescription(), elem, doc);
        for (IRelPropValue iRelPropValue : desc.getValues()) {
            RelPropManager.appendValue(iRelPropValue, elem, doc);
        }
        parent.appendChild(elem);
    }

    protected static void appendValue(IRelPropValue value, Element parent, Document doc) {
        Element elem = doc.createElement("value");
        elem.setAttribute("name", value.getName());
        if (!value.getResultIDs().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> i = value.getResultIDs().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(" ");
            }
            elem.setAttribute("result", sb.toString());
        }
        RelPropManager.appendDescription(value.getDescription(), elem, doc);
        parent.appendChild(elem);
    }

    protected static void appendDescription(String desc, Element parent, Document doc) {
        if (desc == null || desc.length() == 0) {
            return;
        }
        Element elem = doc.createElement("description");
        elem.setTextContent(desc);
        parent.appendChild(elem);
    }
}

