/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.controllers.SegmentController;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventClassifer;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.model.EventModel;
import edu.mit.semantics.core.rep.event.model.IEventModel;
import edu.mit.semantics.ui.controllers.IEventController;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;

public class EventController
implements IEventController {
    private final IStoryEditor editor;
    private final IEventModel model;
    private final ISegmentSetController eventController;
    private final ISegmentSetController headController;
    private final ISegmentController polController;
    private final ISegmentController cardController;
    private final ISegmentController modeController;

    public EventController(IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = new EventModel((IStoryModel)editor.getStoryModel());
        this.eventController = new SegmentSetController(this.model.getEventModel(), editor, "edu.mit.story.ui.annotation.target1"){

            protected void updateRanges(IntervalSet intervals) {
                super.updateRanges(intervals);
                EventClassifer.getInstance().classify(EventController.this.model);
            }
        };
        this.headController = new SegmentSetController(this.model.getHeadModel(), editor, "edu.mit.story.ui.annotation.target2"){

            protected void updateRanges(IntervalSet intervals) {
                super.updateRanges(intervals);
                EventClassifer.getInstance().classify(EventController.this.model);
            }
        };
        this.polController = new SegmentController(this.model.getPolarityModel(), "edu.mit.story.ui.annotation.target3", editor);
        this.cardController = new SegmentController(this.model.getCardinalityModel(), "edu.mit.story.ui.annotation.target4", editor);
        this.modeController = new SegmentController(this.model.getModalityModel(), "edu.mit.story.ui.annotation.target5", editor);
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public IEventModel getModel() {
        return this.model;
    }

    public ISegmentSetController getEventController() {
        return this.eventController;
    }

    public ISegmentSetController getHeadController() {
        return this.headController;
    }

    public ISegmentController getPolarityController() {
        return this.polController;
    }

    public ISegmentController getCardinalityController() {
        return this.cardController;
    }

    public ISegmentController getModalityController() {
        return this.modeController;
    }

    public void setEventClass(EventClass eventClass) {
        this.getModel().setEventClass(eventClass);
    }

    public void setPOS(POS pos) {
        this.getModel().setPOS(pos);
    }

    public void setTense(Tense tense) {
        this.getModel().setTense(tense);
    }

    public void setAspect(Aspect aspect) {
        this.getModel().setAspect(aspect);
    }

    public void setPolarity(boolean polarity) {
        this.getModel().setPolarity(polarity);
    }

    public void setCardinality(int cardinality) {
        this.getModel().setCardinality(cardinality);
    }

    public void setLoaded(IDesc desc) {
        this.getModel().setLoaded(desc);
    }

    public void clear() {
        this.eventController.clear();
        this.headController.clear();
        this.polController.clear();
        this.cardController.clear();
        this.modeController.clear();
        this.model.clear();
    }

    public void commit() {
        IEvent e = this.model.toEvent();
        Timing timing = new Timing(this.model.getStart(), "user");
        IHasPosition p = e.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)EventRep.getInstance(), (IHasPosition)p, (IData)e, (ITiming)timing, (IDesc)this.model.getLoaded());
        this.clear();
    }

    public void dispose() {
        this.eventController.dispose();
        this.headController.dispose();
        this.polController.dispose();
        this.cardController.dispose();
        this.modeController.dispose();
    }

    public void load(IDesc desc) {
        if (EventRep.getInstance().isType((IHasRep)desc)) {
            this.model.setLoaded(desc);
        }
    }
}

