/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.Immutable;
import edu.mit.story.core.util.ImmutableIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableDescSet
extends AbstractSet<IDesc>
implements IDescSet,
Immutable {
    private static final long serialVersionUID = 1L;
    private final IDescSet backingSet;

    public ImmutableDescSet(IRep rep) {
        this.backingSet = new DescSet(rep);
    }

    public ImmutableDescSet(IRep rep, Collection<? extends IDesc> descs) {
        this.backingSet = new DescSet(rep, descs);
    }

    public ImmutableDescSet(IDescSet wrappedSet) {
        if (wrappedSet == null) {
            throw new NullPointerException();
        }
        this.backingSet = wrappedSet;
    }

    @Override
    public IRep getRep() {
        return this.backingSet.getRep();
    }

    @Override
    public IDesc getDescription(long id) {
        return this.backingSet.getDescription(id);
    }

    @Override
    public IDescSet closedSet(IHasPosition range) {
        IDescSet hidden = this.backingSet.closedSet(range);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public IDescSet matchSet(IHasPosition range) {
        IDescSet hidden = this.backingSet.matchSet(range);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public IDescSet openSet(IHasPosition range) {
        IDescSet hidden = this.backingSet.openSet(range);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public IDescSet subSet(IDesc fromElement, IDesc toElement) {
        IDescSet hidden = this.backingSet.subSet(fromElement, toElement);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public IDescSet headSet(IDesc toElement) {
        IDescSet hidden = this.backingSet.headSet(toElement);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public IDescSet tailSet(IDesc fromElement) {
        IDescSet hidden = this.backingSet.tailSet(fromElement);
        return hidden == null ? null : new ImmutableDescSet(hidden);
    }

    @Override
    public Comparator<? super IDesc> comparator() {
        return this.backingSet.comparator();
    }

    @Override
    public IDesc first() {
        return (IDesc)this.backingSet.first();
    }

    @Override
    public IDesc last() {
        return (IDesc)this.backingSet.last();
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingSet.contains(o);
    }

    @Override
    public Iterator<IDesc> iterator() {
        return new ImmutableIterator<IDesc>(this.backingSet.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.backingSet.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.backingSet.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingSet.containsAll(c);
    }

    @Override
    public int getOffset() {
        return this.backingSet.getOffset();
    }

    @Override
    public int getLength() {
        return this.backingSet.getLength();
    }

    @Override
    public int getRightOffset() {
        return this.backingSet.getRightOffset();
    }

    @Override
    public int compareTo(IDescSet o) {
        return this.backingSet.compareTo(o);
    }

    @Override
    public int getImplementationCode() {
        return this.backingSet.getImplementationCode();
    }

    @Override
    public String getImplementationName() {
        return this.backingSet.getImplementationName();
    }

    @Override
    public String getSerializedData() {
        return this.backingSet.getSerializedData();
    }

    public Object getAdapter(Class adapter) {
        return this.backingSet.getAdapter(adapter);
    }

    @Override
    public boolean equals(IDescSet tgtDescs, IAlignedStoryModel model) {
        return this.backingSet.equals(tgtDescs, model);
    }
}

