/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc.factory;

import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory;
import edu.mit.story.core.desc.factory.IndexedData;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescFactory2<T extends IndexedData<?>>
extends AbstractDescFactory {
    public AbstractDescFactory2(IRep rep, IRep requiredRep) {
        super(rep, requiredRep);
    }

    public AbstractDescFactory2(IRep rep, IRep ... requiredReps) {
        super(rep, requiredReps);
    }

    public AbstractDescFactory2(IRep rep, Collection<? extends IRep> requiredReps) {
        super(rep, requiredReps);
    }

    @Override
    protected IDescSet doCalculateDescriptions(IHasPosition range, IStoryModel provider) {
        DescSet result = new DescSet(this.getRep());
        if (range == null | provider == null) {
            return result;
        }
        IHasPositionSet<T> indexedData = this.calculateData(range, provider);
        if (indexedData == null) {
            return result;
        }
        for (IndexedData data : indexedData) {
            result.add(this.toDescription(data, provider));
        }
        return result;
    }

    @Override
    protected StoryChangeEvent doApplyChanges(StoryChangeEvent event) {
        DistinctRegionSet regions = this.calculateRegions(event);
        if (regions == null || regions.size() == 0) {
            return null;
        }
        IDescSet origDescs = event.provider.getData().getDescriptions(this.getRep());
        ArrayList<IHasPositionSet<T>> regionData = new ArrayList<IHasPositionSet<T>>(regions.size());
        ArrayList<IDescSet> regionDescs = new ArrayList<IDescSet>(regions.size());
        for (IHasPosition region : regions) {
            regionData.add(this.calculateData(region, event.provider));
            regionDescs.add(origDescs.openSet(region));
        }
        LinkedList<IDesc> toAdd = new LinkedList<IDesc>();
        LinkedList<IDesc> toRemove = new LinkedList<IDesc>();
        int i = 0;
        while (i < regions.size()) {
            IDesc desc;
            Iterator itr;
            IHasPositionSet data = (IHasPositionSet)regionData.get(i);
            IDescSet subset = (IDescSet)regionDescs.get(i);
            if (data == null || data.isEmpty()) {
                itr = subset.iterator();
                while (itr.hasNext()) {
                    desc = (IDesc)itr.next();
                    if (this.mustKeep(desc)) continue;
                    itr.remove();
                    toRemove.add(desc);
                }
            } else {
                itr = subset.iterator();
                while (itr.hasNext()) {
                    desc = (IDesc)itr.next();
                    boolean keepDesc = this.mustKeep(desc);
                    Iterator j = data.iterator();
                    while (j.hasNext()) {
                        IndexedData idxData = (IndexedData)j.next();
                        if (!idxData.equals(desc) && (!idxData.replaces(desc) || !this.mustKeep(desc))) continue;
                        j.remove();
                        keepDesc = true;
                    }
                    if (keepDesc) continue;
                    itr.remove();
                    toRemove.add(desc);
                }
                for (IndexedData newData : data) {
                    if (newData.getLength() < this.getRep().getMinimumDescriptionLength() || (desc = this.toDescription(newData, event.provider)) == null) continue;
                    subset.add(desc);
                    toAdd.add(desc);
                }
            }
            ++i;
        }
        if (toRemove == null & toAdd == null) {
            return null;
        }
        this.saveDeleted(toRemove, event.provider.getData());
        StoryChangeEventIntegrator integrator = event.createIntegrator();
        integrator.descriptionsRemoved(toRemove);
        integrator.descriptionsAdded(toAdd);
        return integrator.asEvent();
    }

    protected boolean mustKeep(IDesc d) {
        if (OriginMetaRep.isUserSpecified(d)) {
            return true;
        }
        return !MergeMetaRep.extractMergeProfile(d).isEmpty();
    }

    protected IDesc toDescription(T idxData, IStoryModel provider) {
        Desc desc = new Desc(provider.getNextID(), this.getRep(), (IHasPosition)idxData, (IData)((IndexedData)idxData).getData(), null);
        Timing timing = new Timing(this.getID(), true);
        MetaDesc<Timing> metadesc = new MetaDesc<Timing>(TimingMetaRep.getInstance(), desc, timing);
        desc.getMetaData().addDesc(metadesc);
        return desc;
    }

    protected abstract DistinctRegionSet calculateRegions(StoryChangeEvent var1);

    protected abstract IHasPositionSet<T> calculateData(IHasPosition var1, IStoryModel var2);
}

