/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.mappers.IValueMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMapper
implements IValueMapper<Long> {
    private static LongMapper instance = null;
    private static Pattern comma = Pattern.compile(",");

    public static LongMapper getInstance() {
        if (instance == null) {
            instance = new LongMapper();
        }
        return instance;
    }

    protected LongMapper() {
    }

    @Override
    public List<Long> reconstitute(String value) {
        return LongMapper.toObjectsStatic(value);
    }

    @Override
    public String serialize(Collection<? extends Long> objects) {
        return LongMapper.toValueStatic(objects);
    }

    public static List<Long> toObjectsStatic(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        String[] ids = comma.split(trimmed);
        if (ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                result.add(Long.decode(id));
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return result;
    }

    public static String toValueStatic(Collection<? extends Long> objects) {
        StringBuffer sb = new StringBuffer();
        if (objects != null) {
            Iterator<? extends Long> i = objects.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }
}

