/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.rep.IRep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDesc<D extends IMetaData>
implements IMetaDesc<D> {
    private final IMetaRep<D> meta;
    private final IRep rep;
    private final D data;
    private final String dataStr;
    private final long id;

    public MetaDesc(IMetaRep<D> meta, IRep rep, D data) {
        this(meta, rep, -1L, data, null);
    }

    public MetaDesc(IMetaRep<D> meta, IRep rep, D data, String dataStr) {
        this(meta, rep, -1L, data, dataStr);
    }

    public MetaDesc(IMetaRep<D> meta, IRep rep, long id, D data) {
        this(meta, rep, id, data, null);
    }

    public MetaDesc(IMetaRep<D> meta, IRep rep, long id, D data, String dataStr) {
        if (meta == null) {
            throw new NullPointerException();
        }
        if (rep == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (id < -1L) {
            throw new IllegalArgumentException();
        }
        this.meta = meta;
        this.rep = rep;
        this.data = data;
        this.id = id;
        this.dataStr = dataStr == null ? meta.serialize(data) : dataStr;
    }

    public MetaDesc(IMetaRep<D> meta, IDesc desc, D data) {
        this(meta, desc, data, null);
    }

    public MetaDesc(IMetaRep<D> meta, IDesc desc, D data, String dataStr) {
        if (meta == null) {
            throw new NullPointerException();
        }
        if (desc == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.meta = meta;
        this.rep = desc.getRep();
        this.data = data;
        this.id = desc.getID();
        this.dataStr = dataStr == null ? meta.serialize(data) : dataStr;
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public String getSerializedData() {
        return this.dataStr;
    }

    @Override
    public long getDescriptionID() {
        return this.id;
    }

    @Override
    public IRep getRep() {
        return this.rep;
    }

    @Override
    public IMetaRep<D> getMetaRep() {
        return this.meta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.meta.getID());
        sb.append('@');
        sb.append(',');
        if (this.id > -1L) {
            sb.append(Long.toString(this.id));
            sb.append(',');
        }
        sb.append(this.rep.getID());
        sb.append(':');
        sb.append(this.dataStr);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(IMetaDesc<D> o) {
        int cmp = this.rep.compareTo(o.getRep());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (int)this.id - (int)o.getDescriptionID();
        if (cmp != 0) {
            return cmp;
        }
        return this.dataStr.compareTo(o.getSerializedData());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.meta.hashCode();
        result = 31 * result + this.rep.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaDesc other = (MetaDesc)obj;
        if (this.meta != other.meta) {
            return false;
        }
        if (this.rep != other.rep) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.dataStr.equals(other.dataStr);
    }
}

