/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import java.util.Arrays;
import org.eclipse.jface.text.rules.IWhitespaceDetector;

public class WhitespaceDetector
implements IWhitespaceDetector {
    char[] fIgnore;

    public WhitespaceDetector() {
        this(null);
    }

    public WhitespaceDetector(char[] ignore) {
        this.setIgnoreCharacters(ignore);
    }

    public void setIgnoreCharacters(char[] ignore) {
        if (ignore == null) {
            this.fIgnore = null;
        } else {
            this.fIgnore = new char[ignore.length];
            System.arraycopy(ignore, 0, this.fIgnore, 0, ignore.length);
            Arrays.sort(this.fIgnore);
        }
    }

    public char[] getIgnoreCharacters() {
        if (this.fIgnore == null) {
            return null;
        }
        char[] result = new char[this.fIgnore.length];
        System.arraycopy(this.fIgnore, 0, result, 0, this.fIgnore.length);
        return result;
    }

    public boolean isWhitespace(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        if (this.fIgnore != null) {
            return Arrays.binarySearch(this.fIgnore, c) >= 0;
        }
        return false;
    }
}

