/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.rep.text.WhitespaceDetector;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.rules.IWhitespaceDetector;

public class WhitespaceStringTokenizer {
    public static final IWhitespaceDetector defaultDetector = new WhitespaceDetector();
    int currentIdx = 0;
    int stringLength;
    String string;
    IWhitespaceDetector detector;
    String nextToken = null;

    public WhitespaceStringTokenizer(String string) {
        this(string, defaultDetector);
    }

    public WhitespaceStringTokenizer(String string, IWhitespaceDetector detector) {
        this.string = string;
        this.detector = detector;
        this.stringLength = string.length();
        this.nextToken = this.advance();
    }

    protected String advance() {
        while (this.currentIdx < this.stringLength) {
            if (!this.detector.isWhitespace(this.string.charAt(this.currentIdx))) break;
            ++this.currentIdx;
        }
        int begin = this.currentIdx;
        while (this.currentIdx < this.stringLength) {
            if (this.detector.isWhitespace(this.string.charAt(this.currentIdx))) break;
            ++this.currentIdx;
        }
        if (begin == this.currentIdx) {
            return null;
        }
        return this.string.substring(begin, this.currentIdx);
    }

    public boolean hasMoreTokens() {
        return this.nextToken != null;
    }

    public String nextToken() {
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        String next = this.nextToken;
        this.nextToken = this.advance();
        return next;
    }
}

