/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectionDialogCaptureStrategy
implements ICaptureStrategy {
    private final IStoryEditor editor;

    public AbstractSelectionDialogCaptureStrategy(IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public IDesc capture() {
        IHasPosition selection = this.editor.getSelectedRange();
        if (selection == null) {
            return null;
        }
        HasPositionSet list = new HasPositionSet();
        for (IRep rep : this.getReps()) {
            IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
            descs = selection.getLength() == 0 ? descs.closedSet(selection) : descs.openSet(selection);
            list.addAll((Collection)descs);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (IDesc)list.first();
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.editor.getEditorSite().getShell(), this.getLabelProvider());
        dialog.setMultipleSelection(false);
        dialog.setAllowDuplicates(true);
        dialog.setTitle("Select a Description");
        dialog.setMessage("Please select the appropriate description");
        dialog.setElements(list.toArray());
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        Object[] objects = dialog.getResult();
        if (objects.length != 1) {
            return null;
        }
        return (IDesc)objects[0];
    }

    protected abstract Set<IRep> getReps();

    protected abstract ILabelProvider getLabelProvider();
}

