/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.core.descriptor.ICreatableDescriptor;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.HasRepComparator;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.document.IStoryDocument;
import edu.mit.story.ui.editor.IStoryTextHover;
import edu.mit.story.ui.editor.IStoryTextHoverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class StoryEditorTextHover
implements ITextHover {
    private final List<IStoryTextHover> hovers;

    public StoryEditorTextHover() {
        IStoryTextHoverManager manager = StoryUIPlugin.getDefault().getStoryTextHoverManager();
        List ds = manager.getDescriptors();
        ArrayList<IStoryTextHover> hidden = new ArrayList<IStoryTextHover>(ds.size());
        for (ICreatableDescriptor d : manager.getDescriptors()) {
            IStoryTextHover h = (IStoryTextHover)d.create();
            h.init();
            hidden.add(h);
        }
        Collections.sort(hidden, HasRepComparator.getInstance());
        this.hovers = Collections.unmodifiableList(hidden);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public String getHoverInfo(final ITextViewer textViewer, IRegion hoverRegion) {
        IStoryDocument d = (IStoryDocument)textViewer.getDocument();
        IUndoableStoryModel model = d.getStoryModel();
        ArrayList<String> infos = new ArrayList<String>(this.hovers.size());
        final Point sel = new Point(-1, -1);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Point p = textViewer.getSelectedRange();
                sel.x = p.x;
                sel.y = p.y;
            }
        });
        SimplePosition selPos = new SimplePosition(sel.x, sel.y);
        for (IStoryTextHover hover : this.hovers) {
            String info = hover.getHoverInfo((IStoryModel)model, hoverRegion.getOffset(), (IHasPosition)selPos);
            if (info == null) continue;
            infos.add(info);
        }
        if (infos.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = infos.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

