/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.IHasIdentifier;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.wizards.GenerateTextsWizard;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTextsHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "edu.mit.story.ui.generateTexts";
    public static final String PARAM_ID = "edu.mit.story.ui.generateTexts.target";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String textTypeName = event.getParameter(PARAM_ID);
        if (textTypeName == null) {
            return null;
        }
        final GenerationTarget group = GenerationTarget.valueOf(textTypeName);
        IRep rep = (IRep)StoryPlugin.getDefault().getRepManager().getDescriptor(group.getID());
        IModelChange change = rep.getBatchModelChange();
        if (change == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    String message = "Text generation for " + group.getName() + " is not enabled.";
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Generation Problem", (String)message);
                }
            });
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        GenerateTextsWizard wizard = new GenerateTextsWizard(group, selection, change);
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenerationTarget implements IHasName,
    IHasIdentifier
    {
        BASE("Base", "edu.mit.parsing.sentence"),
        SENSE("Wordnet Senses", "edu.mit.wordnet.sense"),
        REFEXP_COREF("Referring Expression and Coreference", "edu.mit.discourse.rep.coref"),
        SEMROLE("Semantic Roles", "edu.mit.semantics.semroles"),
        EVENT_TIMEX("Events and Temporal Expressions", "edu.mit.semantics.rep.event"),
        TIMELINK("Temporal Links", "edu.mit.semantics.rep.timelink"),
        REFPROP_CTXREL("Properties and Context Relations", "edu.mit.semantics.rep.contextrelation"),
        MENTAL_STATE("Mental States", "edu.mit.semantics.rep.mentalstate");

        private final String name;
        private final String id;

        private GenerationTarget(String name, String id) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (id.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String getFileExtension() {
            if (this == BASE) {
                return "txt";
            }
            return "sty";
        }
    }

    public static class GenerationTargets
    implements IParameterValues {
        public Map getParameterValues() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            GenerationTarget[] generationTargetArray = GenerationTarget.values();
            int n = generationTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenerationTarget g = generationTargetArray[n2];
                result.put(g.getName(), g.name());
                ++n2;
            }
            return result;
        }
    }
}

