/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.ICreatableDescriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.ui.wizards.MergeBatchWizard;
import edu.mit.story.ui.wizards.MergeWizard;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeTextsHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "edu.mit.story.ui.mergeTexts";
    public static final String PARAM_ID = "edu.mit.story.ui.mergeTexts.profile";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Wizard wizard;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IMergeModel profile = null;
        String profileID = event.getParameter(PARAM_ID);
        if (profileID == null) {
            wizard = new MergeWizard(selection);
        } else {
            final ICreatableDescriptor desc = (ICreatableDescriptor)StoryPlugin.getDefault().getMergeProfileManager().getDescriptor(profileID);
            profile = (IMergeModel)desc.create();
            if (profile == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        String message = "Text merge for " + desc.getName() + " is not enabled.";
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Generation Problem", (String)message);
                    }
                });
                return null;
            }
            wizard = new MergeBatchWizard(selection, profile, desc.getName());
        }
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
        return null;
    }

    public static class MergeProfileTypes
    implements IParameterValues {
        public Map getParameterValues() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (IDescriptor d : StoryPlugin.getDefault().getMergeProfileManager().getDescriptors()) {
                result.put(d.getName(), d.getID());
            }
            return result;
        }
    }
}

