/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateChart
extends Canvas {
    protected Set<Date> dates = new HashSet<Date>();
    private Set<Date> extDates = Collections.unmodifiableSet(this.dates);
    protected Calendar cal = Calendar.getInstance();
    private Date minimum = new Date(0L);
    private Date maximum = new Date(10L);
    private int marginLeft = 10;
    private int marginTop = 10;
    private int marginRight = 10;
    private int marginBottom = 10;
    int headWidth = 2;

    public DateChart(Composite parent, int style) {
        super(parent, style);
        this.setBackground(parent.getDisplay().getSystemColor(25));
        this.setForeground(parent.getDisplay().getSystemColor(24));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DateChart.this.onPaint(e);
            }
        });
    }

    protected void onPaint(PaintEvent e) {
        Rectangle canvas = this.getClientArea();
        if (canvas.width == 0 || canvas.height == 0) {
            return;
        }
        int abscissaY = canvas.y + canvas.height - this.marginBottom;
        int abscissaXleft = canvas.x + this.marginLeft;
        int abscissaWidth = canvas.width - this.marginRight - this.marginLeft;
        e.gc.setForeground(this.getForeground());
        e.gc.drawLine(abscissaXleft, abscissaY, abscissaXleft + abscissaWidth, abscissaY);
        int dataY = canvas.y + this.marginTop;
        long abscissaTimeWidth = this.maximum.getTime() - this.minimum.getTime();
        int halfHeadWidth = this.headWidth / 2;
        int headWidth = 2 * halfHeadWidth;
        for (Date d : this.dates) {
            if (d.before(this.minimum) || d.after(this.maximum)) continue;
            long relTime = d.getTime() - this.minimum.getTime();
            int dataX = (int)((double)relTime / (double)abscissaTimeWidth * (double)abscissaWidth);
            e.gc.drawLine(dataX, dataY, dataX, abscissaY);
            e.gc.drawRectangle(dataX - halfHeadWidth, dataY - halfHeadWidth, headWidth, headWidth);
        }
    }

    public void add(Date d) {
        if (this.dates.add(d)) {
            this.redraw();
        }
    }

    public void remove(Date d) {
        if (this.dates.remove(d)) {
            this.redraw();
        }
    }

    public void removeAll() {
        if (this.dates.isEmpty()) {
            return;
        }
        this.dates.clear();
        this.redraw();
    }

    public Set<Date> getDates() {
        return this.extDates;
    }

    public Date getMinimum() {
        return this.minimum;
    }

    public Date getMaximum() {
        return this.maximum;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMinimum(Date minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(Date maximum) {
        this.maximum = maximum;
    }

    public void setMarginWidth(int width) {
        this.setMargins(width, width, width, width);
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.setLeftMargin(left);
        this.setTopMargin(top);
        this.setRightMargin(right);
        this.setBottomMargin(bottom);
    }

    public void setLeftMargin(int pixels) {
        this.checkMargin(pixels);
        this.marginLeft = pixels;
    }

    public void setTopMargin(int pixels) {
        this.checkMargin(pixels);
        this.marginTop = pixels;
    }

    public void setRightMargin(int pixels) {
        this.checkMargin(pixels);
        this.marginRight = pixels;
    }

    public void setBottomMargin(int pixels) {
        this.checkMargin(pixels);
        this.marginBottom = pixels;
    }

    protected void checkMargin(int pixels) {
        if (pixels < 0) {
            throw new IllegalArgumentException();
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        shell.setLayout((Layout)layout);
        DateChart chart = new DateChart((Composite)shell, 0);
        chart.setLayoutData(new GridData(4, 4, true, true));
        Monitor m = display.getPrimaryMonitor();
        Rectangle screen = m.getBounds();
        int width = screen.width / 3;
        int height = screen.height / 3;
        int x = screen.x + (screen.width - width) / 2;
        int y = screen.y + (screen.height - height) / 2;
        shell.setBounds(x, y, width, height);
        chart.setMargins(20, 40, 20, 40);
        chart.add(new Date(2L));
        chart.add(new Date(3L));
        chart.add(new Date(5L));
        chart.add(new Date(9L));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

