/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.notify.IChangeNotifier;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.ButtonAction;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescCaptureWidget<C extends IDescController<?>>
extends AnnotationWidget<C> {
    private final IDescDisplayText display;
    protected Text tokenText;
    protected Spinner offsetSpinner;
    protected int spinnerValue;
    protected Button captureButton;
    protected Button clearButton;
    protected ButtonAction captureAction;
    protected ButtonAction clearAction;

    public DescCaptureWidget(Composite parent, int style, C controller, IDescDisplayText display) {
        super(parent, style, controller);
        if (display == null) {
            throw new NullPointerException();
        }
        this.display = display;
        ((IChangeNotifier)controller.getDescModel()).addChangeListener((ChangeListener)this);
    }

    public IAction getCaptureAction() {
        return this.captureAction;
    }

    public IAction getClearAction() {
        return this.clearAction;
    }

    @Override
    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout(7, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite leading = new Composite(parent, 0);
        ColorManager.inheritColors((Control)leading);
        leading.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createLeadingControls(leading);
        this.tokenText = new Text(parent, 2048);
        this.tokenText.setBackground(parent.getBackground());
        this.tokenText.setForeground(parent.getForeground());
        this.tokenText.setEditable(false);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 30;
        this.tokenText.setLayoutData((Object)gd);
        this.offsetSpinner = new Spinner(parent, 2056);
        this.offsetSpinner.setBackground(parent.getBackground());
        this.offsetSpinner.setForeground(parent.getForeground());
        this.offsetSpinner.setMinimum(-1);
        this.offsetSpinner.setMaximum(Integer.MAX_VALUE);
        this.offsetSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newValue = DescCaptureWidget.this.offsetSpinner.getSelection();
                DescCaptureWidget.this.offsetSpinner.setSelection(DescCaptureWidget.this.spinnerValue);
                if (newValue > DescCaptureWidget.this.spinnerValue) {
                    ((IDescController)DescCaptureWidget.this.controller).next();
                } else {
                    ((IDescController)DescCaptureWidget.this.controller).previous();
                }
            }
        });
        this.captureButton = new Button(parent, 0);
        this.captureButton.setText("Capture");
        this.captureButton.setToolTipText("Capture token from the editor");
        this.captureAction = new ButtonAction(this.captureButton){

            public void run() {
                ((IDescController)DescCaptureWidget.this.controller).capture();
            }
        };
        this.captureAction.setText("Capture Token");
        this.captureAction.setToolTipText(this.captureButton.getToolTipText());
        Composite following = new Composite(parent, 0);
        ColorManager.inheritColors((Control)following);
        following.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createFollowingControls(following);
        this.clearButton = new Button(parent, 0);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear field");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                ((IDescController)DescCaptureWidget.this.controller).clear();
            }
        };
        this.clearAction.setText("Clear Token");
        this.clearAction.setToolTipText(this.clearButton.getToolTipText());
        this.createAnnotateButton(parent);
    }

    protected void createLeadingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        gd.heightHint = 0;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    protected void createFollowingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        gd.heightHint = 0;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    @Override
    protected void updateFromModel() {
        boolean clearEnabled;
        Object descModel = ((IDescController)this.controller).getDescModel();
        IDesc desc = descModel.getDesc();
        int spinnerSel = desc == null ? 0 : desc.getOffset();
        String displayText = desc == null ? "" : this.display.getDisplayText(desc);
        boolean bl = clearEnabled = !descModel.isCleared();
        if (!this.tokenText.getText().equals(displayText)) {
            this.tokenText.setText(displayText);
        }
        if (this.offsetSpinner.getSelection() != spinnerSel) {
            this.offsetSpinner.setSelection(spinnerSel);
        }
        if (this.spinnerValue != spinnerSel) {
            this.spinnerValue = spinnerSel;
        }
        if (this.clearButton.isEnabled() != clearEnabled) {
            this.clearButton.setEnabled(clearEnabled);
        }
    }
}

