/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.validation.IValidator;
import edu.mit.story.ui.widgets.InputValueGroup;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputIDNumberGroup
extends InputValueGroup<String> {
    private int idLength;
    private Text text;

    public InputIDNumberGroup(Composite parent, String label, String desc, String initialValue, int idLength, IValidator<String> validator) {
        super(parent, label, desc, InputIDNumberGroup.createEmptyID(initialValue, idLength), validator);
        if (idLength < 1) {
            throw new IllegalArgumentException();
        }
        this.idLength = idLength;
        this.createContents();
    }

    @Override
    protected Control getInputWidget() {
        if (this.text == null) {
            this.text = new Text((Composite)this, 2048);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputIDNumberGroup.this.notifyChangeListeners(InputIDNumberGroup.this.text);
                }
            });
            this.text.setTextLimit(this.idLength);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            this.text.setLayoutData((Object)data);
        }
        return this.text;
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String newValue) {
        if (newValue == null) {
            this.text.setText("");
            return;
        }
        this.text.setText(newValue.substring(0, Math.min(newValue.length(), 9)));
    }

    public static String createEmptyID(String initialValue, int len) {
        if (initialValue != null) {
            return initialValue;
        }
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            sb.append('0');
            ++i;
        }
        return sb.toString();
    }
}

