/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.property.CorpusConfiguration;
import edu.mit.story.core.property.IModelConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.build.StoryNature;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.controllers.RepSelectionConsistentController;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import edu.mit.story.ui.ops.CreateStoryFileOperation;
import edu.mit.story.ui.wizards.page.NewStoryPage;
import edu.mit.story.ui.wizards.page.SpecifyStoryRepsPage;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewStoryWizard
extends Wizard
implements INewWizard {
    protected final IRepSelectionController<IRepSelectionModel> controller = new RepSelectionConsistentController<RepSelectionModel>(new RepSelectionModel());
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected NewStoryPage createStoryPage;
    protected SpecifyStoryRepsPage specifyRepsPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(StoryUIMessages.WIZARD_NewStory_title);
        this.setDefaultPageImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/story_wiz.gif"));
        this.setNeedsProgressMonitor(true);
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.createStoryPage = new NewStoryPage(this.controller);
        this.createStoryPage.setSelection((ISelection)this.selection);
        this.addPage((IWizardPage)this.createStoryPage);
        this.specifyRepsPage = new SpecifyStoryRepsPage(this.controller);
        this.addPage((IWizardPage)this.specifyRepsPage);
    }

    public boolean performFinish() {
        IPath path = this.createStoryPage.getFullPath();
        StoryNature nature = StoryNature.getStoryNature(this.createStoryPage.getProject());
        CorpusConfiguration config = new CorpusConfiguration(nature.getProjectConfiguration());
        Set<IRep> wanted = this.specifyRepsPage.getController().getModel().getIncluded();
        LinkedList<IRep> remove = new LinkedList<IRep>();
        for (IRep supported : config.getSupported()) {
            if (wanted.contains(supported)) continue;
            remove.add(supported);
        }
        config.removeAllSupport(remove);
        CreateStoryFileOperation op = new CreateStoryFileOperation(path, null, (IModelConfiguration)config);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            LogUtils.logError((Plugin)StoryUIPlugin.getDefault(), (Throwable)e);
            return false;
        }
        WorkbenchUtils.selectAndReveal((IResource)op.getFile(), this.workbench.getActiveWorkbenchWindow());
        WorkbenchUtils.openEditor(op.getFile(), this.workbench.getActiveWorkbenchWindow());
        return true;
    }
}

