/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.SVNStatus;

public class SVNException
extends TeamException {
    private boolean operationInterrupted;

    public SVNException(int severity, int code, String message, Throwable e) {
        super((IStatus)new SVNStatus(severity, code, message, null));
        this.operationInterrupted = this.getMessage() != null && this.getMessage().indexOf("operation was interrupted") != -1;
    }

    public SVNException(int severity, int code, String message) {
        this(severity, code, message, null);
        this.operationInterrupted = message != null && message.indexOf("operation was interrupted") != -1;
    }

    public SVNException(String message) {
        super((IStatus)new SVNStatus(4, -6, message, null));
        this.operationInterrupted = message != null && message.indexOf("operation was interrupted") != -1;
    }

    public SVNException(String message, boolean operationInterrupted) {
        this(message);
        this.operationInterrupted = operationInterrupted;
    }

    public SVNException(String message, Throwable e) {
        this(4, -6, message, e);
        this.operationInterrupted = this.getMessage() != null && this.getMessage().indexOf("operation was interrupted") != -1;
    }

    public SVNException(IStatus status) {
        super(status);
        this.operationInterrupted = status.getMessage() != null && status.getMessage().indexOf("operation was interrupted") != -1;
    }

    public boolean operationInterrupted() {
        return this.operationInterrupted;
    }

    public static SVNException wrapException(IResource resource, String message, CoreException e) {
        return new SVNException((IStatus)new SVNStatus(4, e.getStatus().getCode(), message, (Throwable)e));
    }

    public static SVNException wrapException(Exception e) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)e).getTargetException();
            if (target instanceof SVNException) {
                return (SVNException)((Object)target);
            }
            t = target;
        }
        return new SVNException((IStatus)new SVNStatus(4, -6, t.getMessage() != null ? t.getMessage() : "", t));
    }

    public static SVNException wrapException(CoreException e) {
        Object status = e.getStatus();
        if (!status.isMultiStatus()) {
            status = new SVNStatus(status.getSeverity(), status.getCode(), status.getMessage(), (Throwable)e);
        }
        return new SVNException((IStatus)status);
    }

    public static SVNException wrapException(TeamException e) {
        if (e instanceof SVNException) {
            return (SVNException)e;
        }
        return new SVNException(e.getStatus());
    }

    public CoreException toCoreException() {
        IStatus status = this.getStatus();
        return new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), 0, status.getMessage(), (Throwable)((Object)this)));
    }
}

