/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class AddIgnoredPatternCommand
implements ISVNCommand {
    private ISVNLocalFolder folder;
    private String pattern;

    public AddIgnoredPatternCommand(ISVNLocalFolder folder, String pattern) {
        this.folder = folder;
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        if (!this.folder.getStatus().isManaged()) {
            throw new SVNException(4, -6, Policy.bind("SVNTeamProvider.ErrorSettingIgnorePattern", this.folder.getIResource().getFullPath().toString()));
        }
        ISVNClientAdapter svnClient = this.folder.getRepository().getSVNClient();
        try {
            OperationManager.getInstance().beginOperation(svnClient);
            try {
                svnClient.addToIgnoredPatterns(this.folder.getFile(), this.pattern);
                ISVNResource[] members = this.folder.members(null, 8);
                IResource[] possiblesIgnores = new IResource[members.length];
                int i = 0;
                while (true) {
                    block7: {
                        if (i < members.length) break block7;
                        this.folder.refreshStatus(false);
                        SVNProviderPlugin.broadcastSyncInfoChanges(possiblesIgnores, false);
                        this.broadcastNestedFolders(possiblesIgnores);
                        break;
                    }
                    possiblesIgnores[i] = ((ISVNLocalResource)members[i]).getIResource();
                    ++i;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
            OperationManager.getInstance().endOperation();
        }
        monitor.done();
    }

    private void broadcastNestedFolders(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 2) {
                IFolder folder = (IFolder)resources[i];
                try {
                    IResource[] children = folder.members(true);
                    SVNProviderPlugin.broadcastSyncInfoChanges(children, false);
                    this.broadcastNestedFolders(children);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }
}

