/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Sizing;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class AvailableIUElement
extends ProvElement
implements IUElement {
    IInstallableUnit iu;
    private static boolean shouldShowSize = false;
    long size = -1L;
    String profileID;
    static /* synthetic */ Class class$0;

    public AvailableIUElement(IInstallableUnit iu, String profileID) {
        this.iu = iu;
        this.profileID = profileID;
    }

    protected String getImageId(Object obj) {
        return "obj/uninstalled_iu_obj.gif";
    }

    public String getLabel(Object o) {
        return this.iu.getId();
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.iu;
        }
        return super.getAdapter(adapter);
    }

    public long getSize() {
        return this.size;
    }

    public void computeSize(IProgressMonitor monitor) {
        if (this.profileID == null) {
            return;
        }
        try {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ProvisioningPlan plan = this.getSizingPlan((IProgressMonitor)mon.newChild(50));
            Sizing info = ProvisioningUtil.getSizeInfo(plan, this.profileID, (IProgressMonitor)mon.newChild(50));
            this.size = info == null ? -2L : info.getDiskSize();
        }
        catch (ProvisionException e) {
            this.handleException((Exception)((Object)e), ProvUIMessages.AvailableIUElement_ProfileNotFound);
            this.size = -2L;
        }
    }

    protected IProfile getProfile() throws ProvisionException {
        return ProvisioningUtil.getProfile(this.profileID);
    }

    protected ProvisioningPlan getSizingPlan(IProgressMonitor monitor) throws ProvisionException {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.profileID);
        request.addInstallableUnits(new IInstallableUnit[]{this.getIU()});
        return ProvisioningUtil.getProvisioningPlan(request, new ProvisioningContext(), monitor);
    }

    public IInstallableUnit getIU() {
        return this.iu;
    }

    public boolean shouldShowSize() {
        return shouldShowSize;
    }

    public boolean shouldShowVersion() {
        return true;
    }
}

