/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class RequirementChange {
    private RequiredCapability applyOn;
    private RequiredCapability newValue;

    public RequirementChange(RequiredCapability applyOn2, RequiredCapability newValue2) {
        if (applyOn2 == null && newValue2 == null) {
            throw new IllegalArgumentException();
        }
        this.applyOn = applyOn2;
        this.newValue = newValue2;
    }

    public RequiredCapability applyOn() {
        return this.applyOn;
    }

    public RequiredCapability newValue() {
        return this.newValue;
    }

    public boolean matches(RequiredCapability toMatch) {
        if (!toMatch.getNamespace().equals(this.applyOn.getNamespace())) {
            return false;
        }
        if (!toMatch.getName().equals(this.applyOn.getName())) {
            return false;
        }
        if (toMatch.getRange().equals((Object)this.applyOn.getRange())) {
            return true;
        }
        return this.intersect(toMatch.getRange(), this.applyOn.getRange()) != null;
    }

    boolean matches(RequirementChange toMatch) {
        return this.matches(toMatch.applyOn());
    }

    protected RequirementChange merge(RequirementChange r2) {
        VersionRange result = this.intersect(this.newValue().getRange(), r2.newValue().getRange());
        if (result == null) {
            return null;
        }
        return new RequirementChange(this.applyOn, MetadataFactory.createRequiredCapability(this.applyOn.getNamespace(), this.applyOn.getName(), result, null, false, false));
    }

    private VersionRange intersect(VersionRange r1, VersionRange r2) {
        Version resultMin = null;
        boolean resultMinIncluded = false;
        Version resultMax = null;
        boolean resultMaxIncluded = false;
        int minCompare = r1.getMinimum().compareTo((Object)r2.getMinimum());
        if (minCompare < 0) {
            resultMin = r2.getMinimum();
            resultMinIncluded = r2.getIncludeMinimum();
        } else if (minCompare > 0) {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum();
        } else if (minCompare == 0) {
            resultMin = r1.getMinimum();
            resultMinIncluded = r1.getIncludeMinimum() && r2.getIncludeMinimum();
        }
        int maxCompare = r1.getMaximum().compareTo((Object)r2.getMaximum());
        if (maxCompare > 0) {
            resultMax = r2.getMaximum();
            resultMaxIncluded = r2.getIncludeMaximum();
        } else if (maxCompare < 0) {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum();
        } else if (maxCompare == 0) {
            resultMax = r1.getMaximum();
            resultMaxIncluded = r1.getIncludeMaximum() && r2.getIncludeMaximum();
        }
        int resultRangeComparison = resultMin.compareTo((Object)resultMax);
        if (resultRangeComparison < 0) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        if (resultRangeComparison == 0 && resultMinIncluded == resultMaxIncluded) {
            return new VersionRange(resultMin, resultMinIncluded, resultMax, resultMaxIncluded);
        }
        return null;
    }

    public boolean isCompatible(RequirementChange other) {
        return this.intersect(this.newValue.getRange(), other.newValue.getRange()) != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.applyOn == null ? 0 : this.applyOn.hashCode());
        result = 31 * result + (this.newValue == null ? 0 : this.newValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementChange other = (RequirementChange)obj;
        if (this.applyOn == null ? other.applyOn != null : !this.applyOn.equals(other.applyOn)) {
            return false;
        }
        return !(this.newValue == null ? other.newValue != null : !this.newValue.equals(other.newValue));
    }
}

