/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.dialogs;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.WordID;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.dialogs.WordConfigurer;
import edu.mit.wordnet.ui.dialogs.WordSearchComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class WordSelectionDialog
extends SelectionStatusDialog {
    private Point fLocation;
    private Point fSize;
    private List<IWord> fHistory;
    private final IDictionary fDict;
    private Set<POS> fInitialPOS = null;
    private String fInitialPattern = "";
    private WordSearchComponent fContent;

    public WordSelectionDialog(Shell parent, IDictionary dict) {
        super(parent);
        if (dict == null) {
            throw new NullPointerException();
        }
        this.fDict = dict;
        this.setTitle(WordnetUIMessages.DIALOG_TITLE_SelectWord);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setUseHistory(boolean useHistory) {
        if (useHistory) {
            if (this.fHistory == null) {
                this.fHistory = new ArrayList<IWord>();
            }
        } else {
            this.fHistory = null;
        }
    }

    public void setInitialPOS(POS ... pos) {
        this.fInitialPOS = pos == null || pos.length == 0 ? Collections.emptySet() : new HashSet<POS>(Arrays.asList(pos));
    }

    public void setInitialPattern(String pattern) {
        this.fInitialPattern = pattern == null ? "" : pattern;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite area = (Composite)super.createDialogArea(parent);
        Label label = new Label(area, 0);
        label.setText(WordnetUIMessages.DIALOG_MESSAGE_WordSearchPrompt);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData(768));
        this.fContent = new WordSearchComponent(area, parent.getStyle(), this.fInitialPattern, this.fInitialPOS, this.fDict, this.fHistory);
        this.fContent.setLayoutData(new GridData(1808));
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                boolean enabled = WordSelectionDialog.this.fContent.selectionExists();
                if (event.item != null && event.item instanceof TableItem && (item = (TableItem)event.item).getData() == WordConfigurer.getSeparatorObject()) {
                    enabled = false;
                }
                WordSelectionDialog.this.getOkButton().setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (WordSelectionDialog.this.getOkButton().isEnabled()) {
                    WordSelectionDialog.this.okPressed();
                }
            }
        });
        return this.fContent;
    }

    public void okPressed() {
        this.fContent.stopSearch();
        super.okPressed();
    }

    public void cancelPressed() {
        this.fContent.stopSearch();
        super.cancelPressed();
    }

    protected void computeResult() {
        IWord result = this.fContent.getResult();
        if (this.fHistory != null) {
            this.fHistory.remove(result);
            this.fHistory.add(0, result);
        }
        ArrayList<IWord> resultList = new ArrayList<IWord>(1);
        resultList.add(result);
        this.setResult(resultList);
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    protected IDialogSettings getSettings() {
        IDialogSettings settings = WordnetUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = settings.getSection(WordSelectionDialog.class.getCanonicalName());
        if (result == null) {
            result = new DialogSettings(WordSelectionDialog.class.getCanonicalName());
            settings.addSection(result);
            result.put("width", 960);
            result.put("height", 6400);
        }
        return result;
    }

    protected void readSettings() {
        IDialogSettings settings = this.getSettings();
        try {
            int x = settings.getInt("xpos");
            int y = settings.getInt("ypos");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = settings.getInt("width");
            int height = settings.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
        if (this.fHistory != null) {
            String[] wordIDs = settings.getArray("history");
            if (wordIDs == null) {
                return;
            }
            String[] stringArray = wordIDs;
            int n = wordIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String wordID = stringArray[n2];
                IWord word = this.fDict.getWord(WordID.parseWordID((String)wordID));
                if (word != null) {
                    this.fHistory.add(word);
                }
                ++n2;
            }
        }
    }

    protected void writeSettings() {
        IDialogSettings settings = this.getSettings();
        Point location = this.getShell().getLocation();
        settings.put("xpos", location.x);
        settings.put("ypos", location.y);
        Point size = this.getShell().getSize();
        settings.put("width", size.x);
        settings.put("height", size.y);
        if (this.fHistory != null) {
            String[] wordIDs = new String[this.fHistory.size()];
            int i = 0;
            while (i < this.fHistory.size()) {
                wordIDs[i] = ((IWordID)this.fHistory.get(i).getID()).toString();
                ++i;
            }
            settings.put("history", wordIDs);
        }
    }

    public static IWord open(Shell shell, IDictionary dict) {
        return WordSelectionDialog.open(shell, dict, null);
    }

    public static IWord open(Shell shell, IDictionary dict, String stem) {
        return WordSelectionDialog.open(shell, dict, stem, null);
    }

    public static IWord open(Shell shell, IDictionary dict, String stem, POS ... pos) {
        return WordSelectionDialog.open(shell, dict, stem, true, pos);
    }

    public static IWord open(Shell shell, IDictionary dict, String stem, boolean useHistory, POS ... pos) {
        WordSelectionDialog dialog = new WordSelectionDialog(shell, dict);
        dialog.setInitialPattern(stem);
        dialog.setInitialPOS(pos);
        dialog.setUseHistory(useHistory);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        return (IWord)SelectionUtils.extractSingle((Object[])dialog.getResult(), IWord.class);
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }
}

