/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.handlers;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.WordnetStemmer;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.core.WordnetPlugin;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import edu.mit.wordnet.ui.dialogs.WordSelectionDialog;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class BrowseDictionaryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        WordnetStemmer s;
        List stems;
        String text = this.getSelectedText(event);
        IDictionary dict = this.getDictionary(event);
        if (text != null && !(stems = (s = new WordnetStemmer(dict)).findStems(text, null)).isEmpty()) {
            text = (String)stems.get(0);
        }
        WordSelectionDialog.open(HandlerUtil.getActiveShell((ExecutionEvent)event), dict, text, false, POS.values());
        return null;
    }

    protected String getSelectedText(ExecutionEvent event) {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(part instanceof IStoryEditor)) {
            return null;
        }
        IHasPosition p = null;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof TextSelection) {
            TextSelection tsel = (TextSelection)sel;
            p = new SimplePosition(tsel.getOffset(), tsel.getLength());
        } else if (sel instanceof IStructuredSelection) {
            p = (IHasPosition)SelectionUtils.extractSingle((ISelection)sel, IHasPosition.class);
        }
        if (p == null) {
            return null;
        }
        IStoryEditor editor = (IStoryEditor)part;
        IStoryData data = editor.getStoryModel().getData();
        if (data.supports(TokenRep.getInstance())) {
            IDescSet tokens = data.getDescriptions(TokenRep.getInstance()).closedSet(p);
            if (tokens.isEmpty()) {
                tokens = data.getDescriptions(TokenRep.getInstance()).openSet(p);
            }
            StringBuilder sb = new StringBuilder();
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                IToken token = (IToken)((IDesc)i.next()).getData();
                sb.append(token.getSurface());
                if (!token.isFollowedByBreak() || !i.hasNext()) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        return TextRep.getPrettyText((IHasPosition)p, (IStoryData)data);
    }

    protected IDictionary getDictionary(ExecutionEvent event) {
        IExtendedDictionary d;
        IStoryEditor editor;
        IUndoableStoryModel model;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof IStoryEditor && (model = (editor = (IStoryEditor)part).getStoryModel()).supports(SenseRep.getInstance()) && (d = SenseRep.getDictionary((IStoryData)editor.getStoryModel().getData())) != null) {
            return d;
        }
        return WordnetPlugin.getDefault().getDictionaryManager().getLatestDictionary();
    }
}

