/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.dialogs.DifferencesDialog;

public class ShowDifferencesAsUnifiedDiffAction
extends WorkbenchWindowAction {
    private boolean usePegRevision;

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        String fromRevision = null;
        String toRevision = null;
        ISVNRemoteResource[] selectedResources = this.getSelectedRemoteResources();
        if (selectedResources == null || selectedResources.length == 0) {
            Object[] selectedObjects = this.selection.toArray();
            if (selectedObjects[0] instanceof ILogEntry) {
                selectedResources = new ISVNResource[2];
                selectedResources[0] = ((ILogEntry)selectedObjects[0]).getResource();
                fromRevision = ((ILogEntry)selectedObjects[0]).getRevision().toString();
                if (selectedObjects.length > 1) {
                    selectedResources[1] = ((ILogEntry)selectedObjects[1]).getResource();
                    toRevision = ((ILogEntry)selectedObjects[1]).getRevision().toString();
                }
            }
        } else {
            if (selectedResources[0] instanceof ISVNRemoteResource) {
                fromRevision = selectedResources[0].getRevision().toString();
            }
            if (selectedResources.length > 1 && selectedResources[1] instanceof ISVNRemoteResource) {
                toRevision = selectedResources[1].getRevision().toString();
            }
        }
        DifferencesDialog dialog = new DifferencesDialog(this.getShell(), null, (ISVNResource[])selectedResources, this.getTargetPart());
        dialog.setUsePegRevision(this.usePegRevision);
        if (!fromRevision.equals("HEAD")) {
            dialog.setFromRevision(fromRevision);
        }
        if (toRevision != null && !toRevision.equals("HEAD")) {
            dialog.setToRevision(toRevision);
        }
        dialog.open();
    }

    protected boolean isEnabled() throws TeamException {
        Object[] selectedObjects = this.selection.toArray();
        if (selectedObjects.length == 0 || selectedObjects.length > 2) {
            return false;
        }
        ISVNResource svnResource1 = null;
        ISVNResource svnResource2 = null;
        if (selectedObjects[0] instanceof ISVNResource) {
            svnResource1 = (ISVNResource)selectedObjects[0];
        } else if (selectedObjects[0] instanceof ILogEntry) {
            svnResource1 = ((ILogEntry)selectedObjects[0]).getResource();
        }
        if (svnResource1 == null) {
            return false;
        }
        if (selectedObjects.length > 1) {
            if (selectedObjects[1] instanceof ISVNResource) {
                svnResource2 = (ISVNResource)selectedObjects[1];
            } else if (selectedObjects[1] instanceof ILogEntry) {
                svnResource2 = ((ILogEntry)selectedObjects[1]).getResource();
            }
            if (!svnResource1.getRepository().getRepositoryRoot().toString().equals(svnResource2.getRepository().getRepositoryRoot().toString())) {
                return false;
            }
            return svnResource1.isFolder() == svnResource2.isFolder();
        }
        return true;
    }

    protected String getImageId() {
        return "Menu Diff";
    }

    public void setUsePegRevision(boolean usePegRevision) {
        this.usePegRevision = usePegRevision;
    }
}

