/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.parse;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
implements ITree {
    private final String label;
    private final List<? extends ITree> children;
    private boolean isParentSet = false;
    private ITree parent = null;
    private ITree root;
    private IDescSet tokens;
    private List<ITree> leaves;
    private Map<IDesc, ITree> leafMap;
    private int height = -2;
    private int terminal = -1;

    public Tree() {
        this("", Collections.emptyList(), false);
    }

    public Tree(String label, IDesc token) {
        this(label, Collections.emptyList(), false);
        if (token == null) {
            throw new NullPointerException();
        }
        this.tokens = new ImmutableDescSet((IDescSet)new DescSet(token));
    }

    public Tree(String label, List<? extends ITree> children) {
        this(label, children, true);
    }

    public Tree(String label, List<? extends ITree> children, boolean reallocate) {
        this.label = label == null ? "" : label;
        this.children = reallocate ? Collections.unmodifiableList(new ArrayList<ITree>(children)) : children;
        for (ITree iTree : children) {
            iTree.setParent(this);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IDescSet getTokens() {
        if (this.tokens == null) {
            DescSet hidden = new DescSet(TokenRep.getInstance());
            for (IDesc token : this.getLeafMap().keySet()) {
                hidden.add((Object)token);
            }
            this.tokens = new ImmutableDescSet((IDescSet)hidden);
        }
        return this.tokens;
    }

    @Override
    public int getHeight() {
        if (this.height < -1) {
            this.height = this.isLeaf() ? -1 : this.getChildren().get(0).getHeight() + 1;
        }
        return this.height;
    }

    @Override
    public int getTerminal() {
        if (this.terminal < 0) {
            this.terminal = this.isLeaf() ? this.getRoot().getLeaves().indexOf(this) : this.getChildren().get(0).getTerminal();
        }
        return this.terminal;
    }

    @Override
    public boolean isRoot() {
        if (!this.isParentSet) {
            throw new IllegalStateException();
        }
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public ITree getRoot() {
        if (this.root == null) {
            ITree next = this;
            while (!next.isRoot()) {
                next = next.getParent();
            }
            this.root = next;
        }
        return this.root;
    }

    @Override
    public ITree getParent() {
        if (!this.isParentSet) {
            throw new IllegalStateException();
        }
        return this.parent;
    }

    @Override
    public List<? extends ITree> getChildren() {
        return this.children;
    }

    @Override
    public List<? extends ITree> getLeaves() {
        if (this.leaves == null) {
            if (this.children.isEmpty()) {
                this.leaves = Collections.singletonList(this);
            } else {
                LinkedList<ITree> results = new LinkedList<ITree>();
                LinkedList<ITree> queue = new LinkedList<ITree>();
                queue.add(this);
                while (!queue.isEmpty()) {
                    ITree curr = (ITree)queue.poll();
                    if (curr.isLeaf()) {
                        results.add(curr);
                        continue;
                    }
                    ListIterator<? extends ITree> itr = curr.getChildren().listIterator(curr.getChildren().size());
                    while (itr.hasPrevious()) {
                        queue.add(0, itr.previous());
                    }
                }
                this.leaves = Collections.unmodifiableList(new ArrayList(results));
            }
        }
        return this.leaves;
    }

    @Override
    public Map<IDesc, ITree> getLeafMap() {
        if (this.leafMap == null) {
            Map<Object, Object> map;
            List<? extends ITree> leaves = this.getLeaves();
            if (leaves.size() == 1) {
                ITree iTree = leaves.get(0);
                map = Collections.singletonMap((IDesc)iTree.getTokens().first(), iTree);
            } else {
                map = new HashMap(leaves.size());
                for (ITree iTree : leaves) {
                    map.put((IDesc)iTree.getTokens().first(), iTree);
                }
                map = Collections.unmodifiableMap(map);
            }
            this.leafMap = map;
        }
        return this.leafMap;
    }

    @Override
    public void setParent(ITree parent) {
        if (this.isParentSet) {
            throw new IllegalStateException();
        }
        this.isParentSet = true;
        this.parent = parent;
    }

    public IHasPosition calculatePosition() {
        return this.getTokens();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDescSet tokens = model.getData().getDescriptions(TokenRep.getInstance());
        boolean unchanged = true;
        int offset = Integer.MAX_VALUE;
        int rightOffset = 0;
        for (IDesc oldToken : this.getTokens()) {
            IDesc newToken = tokens.getDescription(oldToken.getID());
            if (newToken == null) {
                return null;
            }
            if (newToken != oldToken) {
                unchanged = false;
            }
            offset = Math.min(offset, newToken.getOffset());
            rightOffset = Math.max(rightOffset, newToken.getRightOffset());
        }
        if (unchanged) {
            return this;
        }
        String dataStr = ParseRep.getInstance().serialize((IData)this);
        return (IStructuredData)ParseRep.getInstance().reconstitute((IHasPosition)new SimplePosition(offset, rightOffset - offset), dataStr, model);
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.label;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.label);
        for (ITree iTree : this.children) {
            sb.append(' ');
            sb.append(iTree.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tree other = (Tree)obj;
        if (!this.label.equals(other.label)) {
            return false;
        }
        if (!this.children.equals(other.children)) {
            return false;
        }
        return this.tokens == null || this.tokens.equals((Object)other.tokens);
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    @Override
    public ITree getNode(int height, int terminal) {
        ITree result = this.getLeaves().get(terminal);
        int i = 0;
        while (i <= height) {
            result = result.getParent();
            ++i;
        }
        return result;
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ITree.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ITree tgtTree = (ITree)tgtData;
        int numChildren = this.children.size();
        if (numChildren != tgtTree.getChildren().size()) {
            return false;
        }
        if (numChildren == 0) {
            IDesc tgtLeaf;
            IDesc srcLeaf = (IDesc)this.tokens.first();
            if (!srcLeaf.equals(tgtLeaf = (IDesc)tgtTree.getTokens().first(), model)) {
                return false;
            }
        } else {
            int i = 0;
            while (i < numChildren) {
                if (!this.children.get(i).equals((IData)tgtTree.getChildren().get(i), model)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

