/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.problems;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousStemProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.ambiguousStem";

    public AmbiguousStemProblem(Collection<? extends IDesc> tags, String buildRuleID) {
        super(POSRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Ambiguous Stem");
        this.setDescs(tags);
        this.setSeverity(2);
        IDescSet stemDescs = this.getDescs().getDescriptions(StemRep.getInstance());
        if (stemDescs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IDesc stemDesc : stemDescs) {
            IStem stem = (IStem)stemDesc.getData();
            this.getDescs().add((Object)stem.getWord());
        }
        IDescSet tokens = this.getDescs().getDescriptions(TokenRep.getInstance());
        IDescSet collocs = this.getDescs().getDescriptions(CollocRep.getInstance());
        HasPositionSet words = new HasPositionSet();
        words.addAll((Collection)tokens);
        words.addAll((Collection)collocs);
        if (words.isEmpty()) {
            throw new IllegalArgumentException();
        }
        IDesc d = (IDesc)words.first();
        this.setPosition((IHasPosition)d);
        if (words.size() > 1) {
            this.setDescription("There are " + tags.size() + " words with ambiguous stem assignments (only first shown)");
        } else {
            IBaseToken tok = (IBaseToken)d.getData();
            this.setDescription("The word '" + tok.getSurface() + "' has " + stemDescs.size() + " stems");
        }
    }
}

