/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.token;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import gnu.trove.decorator.TObjectIntMapDecorator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAligner
extends Aligner<IDesc, IDesc> {
    private final TObjectIntHashMap<SimKey> simMap;
    private Map<SimKey, Integer> extSimMap;
    private final IRep rep = TokenRep.getInstance();

    public TokenAligner() {
        this.simMap = new TObjectIntHashMap();
    }

    public TokenAligner(int initialCacheSize) {
        this.simMap = new TObjectIntHashMap(initialCacheSize);
    }

    public Map<SimKey, Integer> getSimCache() {
        if (this.extSimMap == null) {
            this.extSimMap = new TObjectIntMapDecorator(this.simMap);
        }
        return this.extSimMap;
    }

    public int sim(IDesc a, IDesc b) {
        if (!this.rep.isType((IHasRep)a)) {
            throw new IllegalArgumentException();
        }
        if (!this.rep.isType((IHasRep)b)) {
            throw new IllegalArgumentException();
        }
        return this.sim((IToken)a.getData(), (IToken)b.getData());
    }

    public int sim(IToken a, IToken b) {
        String strB;
        String strA = a.getSurface();
        if (strA.equals(strB = b.getSurface())) {
            return 0;
        }
        SimKey key = new SimKey(strA, strB);
        int result = this.simMap.get((Object)key);
        if (result == 0) {
            result = -1 * TokenAligner.levenshteinDistance(strA, strB);
            this.simMap.put((Object)key, result);
        }
        return result;
    }

    public static int levenshteinDistance(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        int i2 = 1;
        while (i2 <= n) {
            char s_i = s.charAt(i2 - 1);
            int j2 = 1;
            while (j2 <= m) {
                char t_j = t.charAt(j2 - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i2][j2] = Math.min(d[i2 - 1][j2] + 1, Math.min(d[i2][j2 - 1] + 1, d[i2 - 1][j2 - 1] + cost));
                ++j2;
            }
            ++i2;
        }
        return d[n][m];
    }

    protected static class SimKey {
        public final String one;
        public final String two;

        public SimKey(String one, String two) {
            if (one == null) {
                throw new NullPointerException();
            }
            if (two == null) {
                throw new NullPointerException();
            }
            this.one = one;
            this.two = two;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.one.hashCode();
            result = 31 * result + this.two.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimKey other = (SimKey)obj;
            if (!this.one.equals(other.one)) {
                return false;
            }
            return this.two.equals(other.two);
        }
    }
}

