/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense;

import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.GenericTag;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.evidence.IEvidence;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;

public class Sense
extends SenseAssignment
implements ISense {
    private IDesc token;
    private IDesc stem;
    private IDesc pos;

    public Sense(IDesc token, IDesc stem, IDesc pos, IWord sense, IEvidence evidence) {
        super(sense, evidence);
        IPosTag p;
        IStem s;
        if (!TokenRep.getInstance().isType((IHasRep)token) && !CollocRep.getInstance().isType((IHasRep)token)) {
            throw new IllegalArgumentException();
        }
        if (stem != null && !StemRep.getInstance().isType((IHasRep)stem)) {
            throw new IllegalArgumentException();
        }
        if (pos != null && !POSRep.getInstance().isType((IHasRep)pos)) {
            throw new IllegalArgumentException();
        }
        if (stem != null && token != (s = (IStem)stem.getData()).getWord()) {
            throw new IllegalArgumentException();
        }
        if (pos != null && token != (p = (IPosTag)pos.getData()).getWord()) {
            throw new IllegalArgumentException();
        }
        this.token = token;
        this.stem = stem;
        this.pos = pos;
    }

    public IDesc getWord() {
        return this.token;
    }

    public IDesc getPOSDesc() {
        return this.pos;
    }

    public IDesc getStemDesc() {
        return this.stem;
    }

    public String getStem() {
        if (this.stem == null) {
            IBaseToken t = (IBaseToken)this.token.getData();
            return t.getSurface().toLowerCase();
        }
        IStem s = (IStem)this.stem.getData();
        return s.getStem();
    }

    public ITag getTag() {
        if (this.pos == null) {
            return GenericTag.UNKNOWN;
        }
        IPosTag tag = (IPosTag)this.pos.getData();
        return tag.getTag();
    }

    public boolean isAuxiliary() {
        if (this.pos == null) {
            return false;
        }
        IPosTag tag = (IPosTag)this.pos.getData();
        return tag.isAuxiliary();
    }

    public IHasPosition calculatePosition() {
        return this.token;
    }

    public IHasPosition getDisplayPosition() {
        return this.token;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newToken = model.getData().getDescriptions(this.token.getRep()).getDescription(this.token.getID());
        if (newToken == null) {
            return null;
        }
        boolean recalculate = this.token != newToken;
        IDesc newPOS = null;
        if (this.pos != null) {
            newPOS = model.getData().getDescriptions(POSRep.getInstance()).getDescription(this.pos.getID());
        }
        if (newPOS == null) {
            IDescSet matches = model.getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)newToken);
            newPOS = this.findMatchingPosDesc(container, matches);
        }
        if (newPOS == null) {
            return null;
        }
        recalculate |= this.pos != newPOS;
        IDesc newStem = null;
        if (this.stem != null) {
            newStem = model.getData().getDescriptions(StemRep.getInstance()).getDescription(this.stem.getID());
        }
        if (newStem == null) {
            IDescSet matches = model.getData().getDescriptions(StemRep.getInstance()).matchSet((IHasPosition)newToken);
            newStem = this.findMatchingStemDesc(container, matches);
        }
        if (recalculate |= this.stem != newStem) {
            return new Sense(newToken, newStem, newPOS, this.getSense(), this.getEvidence());
        }
        return this;
    }

    protected IDesc findMatchingPosDesc(IDesc senseDesc, IDescSet posMatches) {
        LinkedList<IDesc> matching = new LinkedList<IDesc>();
        SortedSet mergeProfile = MergeMetaRep.extractMergeProfile((IDesc)senseDesc);
        for (IDesc posDesc : posMatches) {
            if (!MergeMetaRep.matches((IDesc)posDesc, (Collection)mergeProfile)) continue;
            matching.add(posDesc);
        }
        if (matching.isEmpty()) {
            matching.addAll((Collection<IDesc>)posMatches);
        }
        for (IDesc posDesc : matching) {
            if (!WordnetUtils.matches(posDesc, senseDesc)) continue;
            return posDesc;
        }
        return matching.isEmpty() ? null : (IDesc)matching.get(0);
    }

    protected IDesc findMatchingStemDesc(IDesc senseDesc, IDescSet stemMatches) {
        if (stemMatches.isEmpty()) {
            return null;
        }
        LinkedList<IDesc> matching = new LinkedList<IDesc>();
        SortedSet mergeProfile = MergeMetaRep.extractMergeProfile((IDesc)senseDesc);
        for (IDesc posDesc : stemMatches) {
            if (!MergeMetaRep.matches((IDesc)posDesc, (Collection)mergeProfile)) continue;
            matching.add(posDesc);
        }
        return matching.isEmpty() ? (IDesc)stemMatches.first() : (IDesc)matching.get(0);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ISense.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ISense tgtSense = (ISense)tgtData;
        if (!Data.equals((Object)this.getSense(), (Object)tgtSense.getSense())) {
            return false;
        }
        if (!this.token.equals(tgtSense.getWord(), model)) {
            return false;
        }
        if (!Desc.equals((IDesc)this.pos, (IDesc)tgtSense.getPOSDesc(), (IAlignedStoryModel)model)) {
            return false;
        }
        return Desc.equals((IDesc)this.stem, (IDesc)tgtSense.getStemDesc(), (IAlignedStoryModel)model);
    }
}

