/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.evidence;

import edu.mit.wordnet.core.rep.sense.evidence.EvidenceType;
import edu.mit.wordnet.core.rep.sense.evidence.INumericEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.TypedEvidence;

public class NumericEvidence
extends TypedEvidence
implements INumericEvidence {
    private final float conf;

    public NumericEvidence(float confidence) {
        super(EvidenceType.NUMERIC, Float.toString(confidence));
        NumericEvidence.checkConfidence(confidence);
        this.conf = confidence;
    }

    public float getConfidence() {
        return this.conf;
    }

    public static void checkConfidence(float confidence) {
        if (NumericEvidence.isConfidenceIllegal(confidence)) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isConfidenceIllegal(float confidence) {
        return confidence < 0.0f || 1.0f < confidence;
    }
}

