/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.problems;

import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Collections;

public class MissingStemProblem
extends StoryProblem {
    public static final String ID = "edu.mit.wordnet.core.problem.missingSenseStem";

    public MissingStemProblem(IDesc senseDesc, String buildRuleID) {
        super(SenseRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Missing Stem for Sense");
        this.setSeverity(2);
        this.setDescs(Collections.singleton(senseDesc));
        IDescSet senses = this.getDescs().getDescriptions(SenseRep.getInstance());
        if (senses.size() != 1) {
            throw new IllegalArgumentException();
        }
        IDesc d = (IDesc)senses.first();
        this.setPosition((IHasPosition)d);
        ISense sense = (ISense)d.getData();
        IBaseToken word = (IBaseToken)sense.getWord().getData();
        this.setDescription("The sense for '" + word.getSurface() + "' is missing its stem; please recalculate it");
    }
}

