/* Filename: CreateSenseStoryModelChange.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Mar 2, 2012
 */
package edu.mit.discourse.core.rep.coref.changes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRep;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since StoryWorkbench 1.0
 */
public class GenerateCorefModelChange extends AbstractModelChange {

	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @since StoryWorkbench 1.0
	 */
	public GenerateCorefModelChange() {
		super("Create Sense Annotation Group Story");
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		
		// check preconditions
		Set<IRep> exactReps = new HashSet<IRep>(Arrays.asList(CharRep.getInstance(), TextRep.getInstance(), TokenRep.getInstance(), SentenceRep.getInstance()));		
		if(!exactReps.equals(model.getSupported()))
			throw new IllegalArgumentException();
		
//		IFactoryManager factMan = StoryPlugin.getDefault().getFactoryManager();
		
		List<IRep> reps = new LinkedList<IRep>();
		List<IConfiguration> configs = new LinkedList<IConfiguration>();
		IRepConfiguration factConfigs = new RepConfiguration(new Descriptor("factories", "Factory Configurations", null));

//		// add mwe rep
//		IRep rep = CollocRep.getInstance();
//		reps.add(rep);
//		IFactoryDescriptor factDesc = factMan.getDescriptor(FactoryManager.makeDefaultFactoryID(rep));
//		factConfigs.put(rep.getID(), factDesc.getID());
//		
//		// add pos rep
//		rep = POSRep.getInstance();
//		reps.add(rep);
//		factDesc = factMan.getDescriptor(FactoryManager.makeDefaultFactoryID(rep));
//		factConfigs.put(rep.getID(), factDesc.getID());
//		IConfiguration factConfig = new Configuration(factDesc.getConfigurationDescriptor());
//		factConfig.put(IParsingConstants.FACTORY_PARAM_Tagger, "edu.stanford.parser.postagger.leftthree");
//		factConfigs.putRepConfiguration(rep, factConfig);
//		
//		// add stem rep
//		rep = StemRep.getInstance();
//		reps.add(rep);
//		factDesc = factMan.getDescriptor(FactoryManager.makeDefaultFactoryID(rep));
//		factConfigs.put(rep.getID(), factDesc.getID());
//		factConfig = new Configuration(factDesc.getConfigurationDescriptor());
//		factConfig.put(IParsingConstants.FACTORY_PARAM_Stemmer, "edu.mit.wordnet.stemmer.wordnet");
//		factConfigs.putRepConfiguration(rep, factConfig);
//		
//		// add sense rep
//		rep = SenseRep.getInstance();
//		reps.add(rep);
//		IConfiguration repConfig = new Configuration(SenseRep.getInstance().getConfigurationDescriptor());
//		repConfig.put(IWordnetConstants.PARAM_Rep_Wordnet, "edu.princeton.wordnet.30");
//		factDesc = factMan.getDescriptor(FactoryManager.makeDefaultFactoryID(rep));
//		factConfigs.put(rep.getID(), factDesc.getID());
//		factConfig = new Configuration(factDesc.getConfigurationDescriptor());
//		factConfig.put(IWordnetConstants.PARAM_Factory_SenseTagger, "edu.mit.wordnet.senseTagger.flat");
//		factConfigs.putRepConfiguration(rep, factConfig);
		
		// do changes
		List<IModelChange> changes = new LinkedList<IModelChange>();
		changes.add(new AddRepsWithConfigChange(reps, configs, factConfigs));
		changes.add(new RemoveMetadataChange());
		return new CompositeModelChange(changes).apply(source, model);
	}

}
