/* Filename: DiscourseRelationRep.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 16, 2007
 */
package edu.mit.discourse.core.rep.refexp;

import java.util.List;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;


/** 
 * Referential expressions 
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 16, 2007)
 * @since 1.5.0
 */
public class RefExpRep extends AbstractRep {
	
	public static final String ID = "edu.mit.discourse.rep.refexp";
	
	private static final long serialVersionUID = 1L;
	
	private static IRep instance = null;
	
	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static IRep getInstance(){
		if(instance == null) 
			instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
		return instance;
	}

	/**
	 * TODO: Write comment
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public RefExpRep() {
		super(IRefExp.class, 1);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#initAntecedentsInternal(edu.mit.story.core.rep.IRepSet)
	 */
	@Override
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(TokenRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
	 */
	public String serialize(IData data) {
		IRefExp refexp = (IRefExp)data;
		return SegmentMapper.serializeStatic(refexp.getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public RefExp reconstitute(IHasPosition p, String data, IStoryModel model) {
		SegmentMapper mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
		List<ISegment> segments = mapper.reconstitute(data);
		return new RefExp(segments);
	}
	
}
