/* Filename: AmbiguousSenseProblem.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Nov 1, 2009
 */
package edu.mit.discourse.core.rep.refexp.problems;

import java.util.Collection;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.PositionUtils;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since StoryWorkbench 1.0
 */
public class IdenticalRefexpsProblem extends StoryProblem {
	
	public static final String ID = "edu.mit.parsing.core.problem.identicalRefexps";

	/**
	 * TODO: Write comment
	 *
	 * @since StoryWorkbench 1.0
	 */
	public IdenticalRefexpsProblem(Collection<? extends IDesc> ds, String buildRuleID) {
		super(POSRep.getInstance(), buildRuleID);
		setID(ID);
		setName("Identical Referring Expressions");
		setDescs(ds);
		setSeverity(IMarker.SEVERITY_ERROR);
		
		IDescSet refexps = getDescs().getDescriptions(RefExpRep.getInstance());
		if(refexps.size() < 2)
			throw new IllegalArgumentException();

		IDesc d = refexps.first();
		if(!PositionUtils.equalAsPositions(refexps, d))
			throw new IllegalArgumentException();
		setPosition(d);
		
		IRefExp re = (IRefExp)d.getData();
		StringBuilder sb = new StringBuilder();
		sb.append("There are ");
		sb.append(Integer.toString(refexps.size()));
		sb.append(" instances of the referring expression '");
		sb.append(re.getDisplayText());
		sb.append("'");
		setDescription(sb.toString());
	}

}
