/* Filename: RefExpPropModel.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Feb 14, 2012
 */
package edu.mit.discourse.core.rep.refprops.model;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.NotifyingHasPositionSet;
import edu.mit.story.core.rep.IRep;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class RefExpPropModel extends DescModel implements IRefExpPropModel {
	
	/**
	 * TODO: Write comment
	 *
	 * @param model
	 * @param repArray
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public RefExpPropModel(IStoryModel model) {
		super(model, RefExpRep.getInstance());
	}

	private final MessageProviderManager manager = new MessageProviderManager();
	
	private IHasPositionSet<IReferentPropertyModel> properties = new NotifyingHasPositionSet<IReferentPropertyModel>(
		new INotifyCollectionCallback<IReferentPropertyModel>(){
			public void elementAdded(IReferentPropertyModel added) {
				manager.add(added);
				fireChanged();
			}
			public void elementRemoved(IReferentPropertyModel removed) {
				manager.remove(removed);
				fireChanged();
			}
		}
	);

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel#getProperties()
	 */
	public IHasPositionSet<IReferentPropertyModel> getProperties() {
		return properties;
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.helpers.models.IRefExpModel#load(edu.mit.story.core.desc.IDesc)
	 */
	public void setDesc(IDesc desc) {
		
		internalClear();
		
		if(getStoryModel().supports(RefPropRep.getInstance())){
			IRefExp refexp = (IRefExp)desc.getData();
			IDescSet propDescs = RefPropRep.collectProperties(refexp, getStoryModel());
			IReferentPropertyModel propModel;
			for(IDesc propDesc : propDescs){
				propModel = new ReferentPropertyModel(getStoryModel());
				propModel.load(propDesc);
				properties.add(propModel);
			}
		}
			
		super.setDesc(desc);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#internalClear()
	 */
	@Override
	protected void internalClear() {
		properties.clear();
		super.internalClear();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#isCleared()
	 */
	@Override
	public boolean isCleared() {
		if(!super.isCleared())
			return false;
		if(!properties.isEmpty())
			return false;
		return super.isCleared();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel#getLoaded()
	 */
	public IDesc getLoaded() {
		return getDesc();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IRefExpPropModel#load(edu.mit.story.core.desc.IDesc)
	 */
	public void load(IDesc desc) {
		setDesc(desc);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	public IHasPosition calculatePosition() {
		return getDesc();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	public IHasPosition getDisplayPosition() {
		return getDesc();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IHasDisplayText#getDisplayText()
	 */
	public String getDisplayText() {
		IRefExp refexp = getRefExp();
		return (refexp == null) ?
				"" :
					refexp.getDisplayText();
	}
	
	protected IRefExp getRefExp(){
		IDesc d = getDesc();
		return (d == null) ? 
				null : 
					(IRefExp)d.getData();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IHasSegments#getSegments()
	 */
	public IHasPositionSet<ISegment> getSegments() {
		IRefExp refexp = getRefExp();
		return (refexp == null) ?
				null :
					refexp.getSegments();
	}


	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IHasRep#getRep()
	 */
	public IRep getRep() {
		IRefExp refexp = getRefExp();
		return (refexp == null) ?
				null :
					refexp.getRep();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.desc.IDesc, edu.mit.story.core.model.IStoryModel)
	 */
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		throw new UnsupportedOperationException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

}
